<?php

/**
 * Blog Content Template
 *
 * @package    WordPress
 * @subpackage SAVELIFE
 * @author     Theme Kalia
 * @version    1.0
 */

if ( class_exists( 'Savelife_Resizer' ) ) {
	$img_obj = new Savelife_Resizer();
} else {
	$img_obj = array();
}
$allowed_tags = wp_kses_allowed_html('post');
global $post;
?>
<div <?php post_class(); ?>>
    <!-- News Block -->
    <div class="news-block">
        <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
        	<?php if( has_post_thumbnail() ):?>
            <div class="image">
                <a href="<?php echo esc_url(the_permalink(get_the_id())); ?>"><?php the_post_thumbnail('savelife_1170x400'); ?></a>
            </div>
            <?php endif;?>
            <div class="lower-content">
                <div class="content">
                    <h3><a href="<?php echo esc_url(the_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h3>
                    <ul class="post-meta">
                        <li><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID') )); ?>"><span class="icon far fa-calendar"></span><?php echo wp_kses(get_the_date(), true);?></a></li>
                        <li><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID') )); ?>"><span class="icon far fa-user"></span><?php the_author();?></a></li>
                        <li><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><span class="icon far fa-comment"></span><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
                        <?php if( has_category() ):?>
                        <li class="custom-category"><span class="icon far fa-folder-open"></span><?php the_category(', '); ?></li>
                        <?php endif;?>
                    </ul>
                    <div class="text"><?php the_excerpt(); ?></div>
                    <a href="<?php echo esc_url(the_permalink(get_the_id())); ?>" class="theme-btn btn-style-four m-t30"><span class="btn-title"><?php esc_html_e('Read More', 'savelife'); ?></span></a>
                </div>
            </div>
        </div>
    </div>
</div>