<?php
/**
 * Blog Post Main File.
 *
 * @package SAVELIFE
 * @author  Theme Kalia
 * @version 1.0
 */

get_header();
$data    = \SAVELIFE\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
$options = savelife_WSH()->option();

if ( class_exists( '\Elementor\Plugin' ) && $data->get( 'tpl-type' ) == 'e') {
	
	while(have_posts()) {
	   the_post();
	   the_content();
    }

} else {
?>
    
<!--Page Title-->
<section class="page-title" style="background-image:url(<?php echo esc_url( $data->get( 'banner' ) ); ?>);">
    <div class="auto-container">
        <div class="content-box clearfix">
            <!--Title -->
            <div class="title-column">
                <h1><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h1>
            </div>
            <!--Bread Crumb -->
            <div class="breadcrumb-column">
                <ul class="bread-crumb clearfix">
                    <?php echo savelife_the_breadcrumb(); ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<!--End Page Title-->

<!--Sidebar Page Container-->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'savelife_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">
            	
				<?php while ( have_posts() ) : the_post(); ?>
                    <div class="news-detail">
                        <div class="inner-box">
                            <div class="image">
                                <?php the_post_thumbnail('savelife_770x450'); ?>
                                <div class="post-date"><?php echo get_the_date('d'); ?> <span><?php echo get_the_date('M'); ?></span></div>
                            </div>
                                
                            <div class="lower-content">
                                <div class="upper-box">
                                    <ul class="post-meta">
                                        <li><span class="icon flaticon-comment"></span><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></li>
                                        <li><span class="icon fa fa-user"></span><?php the_author(); ?></li>
                                        <li><span class="icon far fa-folder-open"></span><?php the_category(); ?></li>
                                    </ul>
                                </div>
                                
								<?php the_content(); ?>
                                
                                <!-- Post Share Options-->
                                <div class="post-share-options">
                                    <div class="post-share-inner clearfix">
                                        
                                        <?php if( has_tag() ):?>
                                        <div class="pull-left tags">
                                            <?php the_tags(' ', '', ''); ?>
                                        </div>
                                        <?php endif;?>
                                        
                                        <?php if(function_exists('bunch_share_us')):?>
                                        <?php echo wp_kses(bunch_share_us(get_the_id(),$post->post_name ), true);?>
                                        <?php endif;?>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                    
                    <!--End Single blog Post-->
                    <?php comments_template(); ?>
            	
				<?php endwhile; ?>
                
            </div>
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'savelife_sidebar', $data );
				}
			?>
        </div>
    </div>
</div>
<!--End blog area-->

<?php
}
get_footer();
