<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Urgent_Causes extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_urgent_causes';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Urgent Causes', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'urgent_causes',
            [
                'label' => esc_html__( 'Urgent Causes', 'savelife' ),
            ]
        );
		$this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'image',
            [
                'label' => __( 'Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'raised',
            [
                'label'       => __( 'Raised Amount', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'goal',
            [
                'label'       => __( 'Goal Amount', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'data_bar',
            [
                'label'       => __( 'Data Fill Bar', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label'       => __( 'Button Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Button URL', 'savelife' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'savelife' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!--FullWidth Section-->
        <section class="updated-fullwidth-section">
            <div class="section-outer clearfix">
                <div class="image-column" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>);">
                    <div class="hidden-image"><img src="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>" alt="<?php esc_html_e( 'Awesome Image', 'savelife' );?>"></div>
                </div>
                <div class="content-column" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['image']['id'])); ?>);">
                    <div class="content">
                        <div class="title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                        <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                        <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                        <!--donate info-->
                        <div class="donate-info clearfix">
                            <div class="amount raised">Raised  <span class="theme_color"><?php echo wp_kses( $settings['raised'], true ); ?></span></div>
                            <div class="amount goal">Goal <span class="theme_color"><?php echo wp_kses( $settings['goal'], true ); ?></span></div>
                        </div>
                        <div class="donate-bar wow fadeIn" data-wow-delay="0ms" data-wow-duration="0ms">
                            <div class="bar-inner">
                                <div class="bar" style="width:<?php echo esc_attr( $settings['data_bar'] ); ?>%;"><div class="count-box"><span class="count-text" data-speed="2000" data-stop="<?php echo esc_attr( $settings['data_bar'] ); ?>">0</span>%</div></div>
                            </div>
                        </div>
                        <a href="<?php echo esc_url( $settings['btn_link']['url'] ); ?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses( $settings['btn_title'], true ); ?></span></a>
                    </div>
                </div>
            </div>
        </section>
        <!--End FullWidth Section-->
        
        <?php
    }
}
