<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Upcoming_Events_V2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_upcoming_events_v2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Upcoming Events V2', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'upcoming_events_v2',
            [
                'label' => esc_html__( 'Upcoming Events V2', 'savelife' ),
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'bg_image',
            [
                'label' => __( 'Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'title1',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'date',
            [
                'label'       => __( 'Date', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'location',
            [
                'label'       => __( 'Location', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label'       => __( 'Button Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Button URL', 'savelife' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'savelife' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 3,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'savelife'),
                'options' => get_categories_list('tribe_events_cat')
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

		$count = 1;
		$events = tribe_get_events(array(
			'posts_per_page' => $settings['query_number'],
			'tax_query'=> array(
				array(
					'taxonomy' => 'tribe_events_cat',
					'field' => 'slug',
					'terms' => $settings['query_category']
				)
			)
		)); ?>
        
        <!--Events Section-->
        <section class="updated-events-section">
            <div class="auto-container">
                
                <!-- Sec Title -->
                <div class="sec-title">
                    <div class="title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                
                <div class="row clearfix">
                    
                    <!--Blocks Column-->
                    <div class="blocks-column col-lg-8 col-md-12 col-sm-12">
                        <div class="inner-column">
                        
                            <!--Widget Block-->
                            <?php 
								if ( empty( $events ) ) :
								echo 'Sorry, nothing found.';
								else: 
								foreach( $events as $event ) : 
								
								$event_thumbnail_id = get_post_thumbnail_id($event->ID);
								$event_thumbnail_url = wp_get_attachment_url($event_thumbnail_id);
								
								$start_datetime = tribe_get_start_date( $event->ID );
								$end_datetime = tribe_get_end_date( $event->ID );
								
								$start_date = tribe_get_start_date($event->ID, null, false, 'd' );
								$end_date = tribe_get_end_date($event->ID, null, false, 'd M, Y' );
								
								$start_time = tribe_get_start_time ( $event->ID, 'h:i A' );
								$end_time = tribe_get_end_time ( $event->ID, 'h:i A' );
								
								$location = get_option('location');
							?>
                            <div class="updated-event-block">
                                <div class="inner-box">
                                    <div class="content">
                                        <!--Date Box-->
                                        <div class="date-box">
                                            <div class="date-inner">
                                                <div class="post-date"><span><?php echo get_the_date('d'); ?></span> <?php echo get_the_date('M'); ?></div>
                                                <div class="day">Starts On <?php echo wp_kses($start_time, true); ?></div>
                                            </div>
                                        </div>
                                        <!--Content Box-->
                                        <div class="content-box">
                                            <div class="box-inner">
                                                <h3><a href="<?php echo esc_url(get_permalink($event->ID)); ?>"><?php echo wp_kses(get_the_title( $event->ID ), true);?></a></h3>
                                                <div class="location"><?php echo tribe_get_venue( $event->ID ); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; endif; ?>
                        </div>
                    </div>
                    
                    <!--Widget Column-->
                    <div class="widget-column col-lg-4 col-md-12 col-sm-12">
                        <div class="inner-column" style="background-image: url(<?php echo wp_get_attachment_url($settings['bg_image']['id']); ?>)">
                            <div class="icon-box">
                                <span class="icon flaticon-stopwatch-1"></span>
                            </div>
                            <h3><?php echo wp_kses( $settings['title1'], true ); ?></h3>
                            <ul class="list">
                                <li><span class="icon fa fa-clock"></span> <?php echo wp_kses( $settings['date'], true ); ?></li>
                                <li><span class="icon fa fa-map-marker"></span> <?php echo wp_kses( $settings['location'], true ); ?></li>
                            </ul>
                            <a href="<?php echo esc_url( $settings['btn_link']['url'] ); ?>" class="theme-btn book-btn"><?php echo wp_kses( $settings['btn_title'], true ); ?></a>
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        <!--End Events Section-->
        
        <?php
    }
}
   