<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Testimonials_V1 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_testimonials_v1';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Testimonials V1', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'testimonials_v1',
            [
                'label' => esc_html__( 'Testimonials V1', 'savelife' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 180,
                'min'     => 1,
                'max'     => 1000,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 6,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'savelife' ),
                    'title'      => esc_html__( 'Title', 'savelife' ),
                    'menu_order' => esc_html__( 'Menu Order', 'savelife' ),
                    'rand'       => esc_html__( 'Random', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'savelife' ),
                    'ASC'  => esc_html__( 'ASC', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'savelife'),
                'options' => get_categories_list('testimonials_cat')
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = savelife_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-savelife' );
        $args = array(
            'post_type'      => 'save_testimonials',
            'posts_per_page' => savelife_set( $settings, 'query_number' ),
            'orderby'        => savelife_set( $settings, 'query_orderby' ),
            'order'          => savelife_set( $settings, 'query_order' ),
            'paged'         => $paged
        );

        if( savelife_set( $settings, 'query_category' ) ) $args['testimonials_cat'] = savelife_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );

        if ( $query->have_posts() ) { ?>
        
        <!-- Team Section -->
        <section class="team-section">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                    <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                </div>
                
                <div class="testimonial-carousel-two owl-carousel owl-theme">
                    <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                    <!-- Testimonial Block -->
                    <div class="testimonial-block">
                        <div class="inner-box">
                            <div class="author-image">
                                <?php the_post_thumbnail('savelife_130x130'); ?>
                            </div>
                            <div class="quote-icon flaticon-quote-3"></div>
                            <div class="text"><?php echo wp_kses(wp_trim_words( get_the_content(), $settings['text_limit'] ), true); ?></div>
                            <div class="lower-box">
                                <div class="clearfix">
                                    <div class="pull-left">
                                        <div class="author-name"><?php the_title(); ?></div>
                                        <div class="designation"><?php echo wp_kses(get_post_meta( get_the_id(), 'designation', true ), true); ?></div>
                                    </div>
                                    <div class="pull-right">
                                        <div class="rating">
                                        	<?php $rating = get_post_meta( get_the_id(), 'star_rating', true );
											if(!empty($rating)){
												for ($x = 1; $x <= 5; $x++) {
													if($x <= $rating) echo '<span class="fa fa-star"></span>'; else echo '<span class="fa fa-star-o"></span>';
												}
											} ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
        <!-- End Team Section -->
        
        <?php }

        wp_reset_postdata();
    }
}
