<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Team_V3 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_team_v3';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Team V3', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'team_v3',
            [
                'label' => esc_html__( 'Team V3', 'savelife' ),
            ]
        );
		$this->add_control(
            'bg_image',
            [
                'label' => __( 'Backgruond Shape Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
				'condition' => [
                    'style' => 'style1'
                ]
            ]
        );
		$this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => __( 'Enter your Text', 'savelife' ),
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 4,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'savelife' ),
                    'title'      => esc_html__( 'Title', 'savelife' ),
                    'menu_order' => esc_html__( 'Menu Order', 'savelife' ),
                    'rand'       => esc_html__( 'Random', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'savelife' ),
                    'ASC'  => esc_html__( 'ASC', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'savelife'),
                'options' => get_categories_list('team_cat')
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = savelife_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-savelife' );
        $args = array(
            'post_type'      => 'savelife_team',
            'posts_per_page' => savelife_set( $settings, 'query_number' ),
            'orderby'        => savelife_set( $settings, 'query_orderby' ),
            'order'          => savelife_set( $settings, 'query_order' ),
            'paged'         => $paged
        );

        if( savelife_set( $settings, 'query_category' ) ) $args['team_cat'] = savelife_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );

        if ( $query->have_posts() ) { ?>
        
        <!-- team-section -->
        <section class="team-section sec-pad">
			<div class="pattern-layer" style="background-image: url(<?php echo wp_get_attachment_url($settings['bg_image']['id']); ?>);"></div>
			
            <div class="auto-container">
				<div class="sec-title centered">
                    <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                    <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                </div>
				
                <div class="row clearfix">
                    <?php while($query->have_posts()) : $query->the_post(); ?>
                    <div class="col-lg-3 col-md-6 col-sm-12 team-block">
                        <div class="team-block-one wow fadeInUp animated" data-wow-delay="400ms" data-wow-duration="1500ms">
                            <div class="inner-box">
                                <div class="image-box">
                                    <figure class="image"><?php the_post_thumbnail('savelife_170x170'); ?></figure>
                                </div>
                                <div class="lower-content">
                                    <h4><?php the_title(); ?></h4>
                                    <span class="designation"><?php echo get_post_meta( get_the_id(), 'designation', true ); ?></span>
									
									<?php $icons = get_post_meta( get_the_id(), 'social_profile', true );
										if ( ! empty( $icons ) ) :
									?>
                                    <ul class="social-links clearfix">
                                        <?php foreach ( $icons as $h_icon ) :
										$header_social_icons = json_decode( urldecode( savelife_set( $h_icon, 'data' ) ) );
										if ( savelife_set( $header_social_icons, 'enable' ) == '' ) {
											continue;
										}
										$icon_class = explode( '-', savelife_set( $header_social_icons, 'icon' ) ); ?>
										<li><a href="<?php echo savelife_set( $header_social_icons, 'url' ); ?>" target="_blank"><span class="fab <?php echo esc_attr( savelife_set( $header_social_icons, 'icon' ) ); ?>"></span></a></li>
										<?php endforeach; ?>
                                    </ul>
									<?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
        <!-- team-section end -->
        
        <?php }

        wp_reset_postdata();
    }
}
