<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Slider_V4 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_slider_v4';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Slider V4', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'slider_v4',
            [
                'label' => esc_html__( 'Slider V4', 'savelife' ),
            ]
        );
        $this->add_control(
            'slides',
            [
                'type' => Controls_Manager::REPEATER,
                'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
						[
							'name' => 'content_position',
							'label'   => esc_html__( 'Content Position', 'savelife' ),
							'type'    => Controls_Manager::SELECT,
							'default' => 'left',
							'options' => array(
								'left' => esc_html__( 'Left', 'savelife' ),
								'center' => esc_html__( 'Center', 'savelife' ),
								'right' => esc_html__( 'Right', 'savelife' ),
							),
						],
                        [
                            'name' => 'image',
                            'label' => esc_html__('Image', 'savelife'),
                            'type' => Controls_Manager::MEDIA,
                            'default' => ['url' => Utils::get_placeholder_image_src(),],
                        ],
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'savelife'),
                            'type' => Controls_Manager::TEXT,
                            'label_block' => true,
                        ],
                        [
                            'name' => 'color_title',
                            'label' => esc_html__('Color Title', 'savelife'),
                            'type' => Controls_Manager::TEXT,
                            'label_block' => true,
                        ],
                        [
                            'name' => 'text',
                            'label' => esc_html__('Text', 'savelife'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
                        [
                            'name' => 'btn_title',
                            'label' => esc_html__('Button Title', 'savelife'),
                            'type' => Controls_Manager::TEXT,
                            'label_block' => true,
                        ],
                        [
                            'name' => 'btn_link',
                            'label' => esc_html__('Button Link', 'savelife'),
                            'type' => Controls_Manager::URL,
                            'placeholder' => __( 'https://your-link.com', 'savelife' ),
                            'show_external' => true,
                            'default' => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!--Main Slider-->
        <section class="main-slider">
            <div class="main-slider-carousel owl-carousel owl-theme">
                <?php foreach($settings['slides'] as $key => $item): ?>
                <?php
				if($item['content_position'] == 'center')
					$class = 'center-align';
				else if($item['content_position'] == 'right')
					$class = 'right-align';
				else
					$class = '';
				?>
                <div class="slide" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['image']['id'])); ?>)">
                    <div class="auto-container">
                        <div class="content clearfix <?php echo esc_attr($class); ?>">
                            <h1><?php echo wp_kses($item['title'], true); ?> <br /><?php echo wp_kses($item['color_title'], true); ?></h1>
                            <div class="text"><?php echo wp_kses($item['text'], true); ?></div>
                            <div class="link-box clearfix">
                                <a href="<?php echo esc_url( $item['btn_link']['url'] ); ?>" class="theme-btn btn-style-one"><span class="txt"><?php echo wp_kses($item['btn_title'], true); ?></span></a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <!--Scroll Dwwn Btn-->
            <div class="mouse-btn-down scroll-to-target" data-target=".updated-donation-section">
                <div class="chevron"></div>
                <div class="chevron"></div>
                <div class="chevron"></div>
            </div>
        </section>
        <!--End Main Slider-->
    	
        <?php
    }
}
