<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Services_Slider extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_services_slider';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Services Slider', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'services_slider',
            [
                'label' => esc_html__( 'Services Slider', 'savelife' ),
            ]
        );
		$this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'savelife' ),
				'separator' => 'before',
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'slides',
            [
                'type' => Controls_Manager::REPEATER,
                'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
							'name' => 'icons',
							'label' => esc_html__('Enter The icons', 'savelife'),
							'type' => Controls_Manager::SELECT2,
							'options'  => get_fontawesome_icons()
						],
						[
                            'name' => 'subtitle',
                            'label' => esc_html__('Sub Title', 'savelife'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'savelife'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
                        [
                            'name' => 'button_link',
                            'label' => esc_html__('Button Link', 'savelife'),
                            'type' => Controls_Manager::URL,
                            'placeholder' => __( 'https://your-link.com/', 'savelife' ),
                            'show_external' => true,
                            'default' => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                        ],
                    ]
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!-- Featured Section -->
        <section class="updated-featured-section" style="background-image:url(<?php echo wp_get_attachment_url($settings['bg_image']['id']); ?>)">
            <div class="outer-container">
                <div class="feature-carousel owl-carousel owl-theme">
                    
                    <!-- Updated Feature Block -->
                    <?php foreach($settings['slides'] as $key => $item): ?>
                    <div class="updated-feature-block">
                        <div class="inner-box">
                            <a href="<?php echo esc_url( $item['button_link']['url'] ); ?>" class="overlay-link"></a>
                            <div class="content">
                                <div class="icon-box">
                                    <span class="icon <?php echo esc_attr( $item[ 'icons' ] );?>"></span>
                                </div>
                                <div class="title"><?php echo wp_kses($item['subtitle'], true); ?></div>
                                <h4><?php echo wp_kses($item['title'], true); ?></h4>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    
                </div>
            </div>
        </section>
        <!-- End Featured Section -->
        
        <?php
    }
}
