<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Register_Volunteer extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_register_volunteer';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Register As A Volunteer', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'register_volunteer',
            [
                'label' => esc_html__( 'Register As A Volunteer', 'savelife' ),
            ]
        );
		$this->add_control(
			'style_two',
			[
				'name' => 'style_two',
				'label'   => esc_html__( 'Choose Different Style', 'savelife' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'one',
				'options' => array(
					'one' => esc_html__( 'Choose Style One', 'savelife' ),
					'two'  => esc_html__( 'Choose Style Two', 'savelife' ),
				),
			]
		);
		$this->add_control(
            'pattern_image',
            [
                'label' => __( 'Pattern Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'mailchimp_shortcode',
            [
                'label'       => __( 'Mailchimp Shortcode', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!--Newsleter Section-->
        <section class="newsletter-section margin-bottom <?php if( $settings[ 'style_two' ] == 'two' ) echo 'p-t90'; else echo '';?>">
            <div class="auto-container">
                <div class="inner-container" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['pattern_image']['id'])); ?>)">
                    <div class="row clearfix">
                        <!--Title Column-->
                        <div class="title-column col-lg-6 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <h4><?php echo wp_kses( $settings['title'], true ); ?></h4>
                                <div class="title"><?php echo wp_kses( $settings['text'], true ); ?></div>
                            </div>
                        </div>
                        
                        <!--Form Column-->
                        <div class="form-column col-lg-6 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <!--Subscribe Form-->
                                <div class="subscribe-form">
                                    <?php echo do_shortcode($settings['mailchimp_shortcode']); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--End Newsleter Section-->
        
        <?php
    }
}
