<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Latest_News_V1 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_our_latest_news_v1';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Latest News V1', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'our_latest_news_v1',
            [
                'label' => esc_html__( 'General', 'savelife' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->end_controls_section();
		
		//Left News
		$this->start_controls_section(
            'left_post',
            [
                'label' => esc_html__( 'Left News', 'savelife' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 200,
                'min'     => 1,
                'max'     => 1000,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 1,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'savelife' ),
                    'title'      => esc_html__( 'Title', 'savelife' ),
                    'menu_order' => esc_html__( 'Menu Order', 'savelife' ),
                    'rand'       => esc_html__( 'Random', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'savelife' ),
                    'ASC'  => esc_html__( 'ASC', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'savelife'),
                'options' => get_categories_list()
            ]
        );
        $this->end_controls_section();
		
		//Right News
		$this->start_controls_section(
            'right_post',
            [
                'label' => esc_html__( 'Right News', 'savelife' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
            'text_limits',
            [
                'label'   => esc_html__( 'Text Limit', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 100,
                'min'     => 1,
                'max'     => 1000,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_numbers',
            [
                'label'   => esc_html__( 'Number of post', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 3,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderbys',
            [
                'label'   => esc_html__( 'Order By', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'savelife' ),
                    'title'      => esc_html__( 'Title', 'savelife' ),
                    'menu_order' => esc_html__( 'Menu Order', 'savelife' ),
                    'rand'       => esc_html__( 'Random', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_orders',
            [
                'label'   => esc_html__( 'Order', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'savelife' ),
                    'ASC'  => esc_html__( 'ASC', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_categorys',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'savelife'),
                'options' => get_categories_list()
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = savelife_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-savelife' );
        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => savelife_set( $settings, 'query_number' ),
            'orderby'        => savelife_set( $settings, 'query_orderby' ),
            'order'          => savelife_set( $settings, 'query_order' ),
            'paged'         => $paged
        );

        if ( savelife_set( $settings, 'query_exclude' ) ) {
            $settings['query_exclude'] = explode( ',', $settings['query_exclude'] );
            $args['post__not_in']      = savelife_set( $settings, 'query_exclude' );
        }

        if( savelife_set( $settings, 'query_category' ) ) $args['category_name'] = savelife_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );
		
		//Second Query
		$args2 = array(
            'post_type'      => 'post',
            'posts_per_page' => savelife_set( $settings, 'query_numbers' ),
            'orderby'        => savelife_set( $settings, 'query_orderbys' ),
            'order'          => savelife_set( $settings, 'query_orders' ),
            'paged'         => $paged
        );

        if ( savelife_set( $settings, 'query_excludes' ) ) {
            $settings['query_excludes'] = explode( ',', $settings['query_excludes'] );
            $args2['post__not_in']      = savelife_set( $settings, 'query_excludes' );
        }

        if( savelife_set( $settings, 'query_categorys' ) ) $args2['category_name'] = savelife_set( $settings, 'query_categorys' );
        $query2 = new \WP_Query( $args2 );
		
        if ( $query->have_posts() ) { ?>
        
        <!-- News Section -->
        <section class="news-section">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title centered">
                    <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                    <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                </div>
                
                <div class="row clearfix">
                    <!-- Column -->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <?php $i=1; while ( $query->have_posts() ) : $query->the_post(); ?>
                        <!-- News Block -->
                        <div class="news-block">
                            <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                                <?php if($i == 1) { ?>
                                <div class="image">
                                    <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_post_thumbnail('savelife_570x350'); ?></a>
                                </div>
                                <?php } ?>
                                <div class="lower-content">
                                    <div class="content">
                                        <h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                                        <ul class="post-meta">
                                            <li><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><span class="icon flaticon-chat-comment-oval-speech-bubble-with-text-lines"></span><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
                                            <li class="custom-category"><span class="icon far fa-folder-open"></span><?php the_category(', '); ?></li>
                                        </ul>
                                        <div class="text"><?php echo wp_kses( wp_trim_words( get_the_content(), $settings['text_limit'] ), true); ?></div>
                                        <a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>" class="read-more"><?php esc_html_e('Read More', 'savelife'); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php $i++; endwhile; ?>
                    </div>
                    
                    <!-- Column -->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <?php while ( $query2->have_posts() ) : $query2->the_post(); ?>
                        <!-- News Block -->
                        <div class="news-block-two">
                            <div class="inner-box wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                                <div class="image-layer" style="background-image: url(<?php $src = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_id()), false, '' ); echo $src[0]; ?>)"></div>
                                <div class="content">
                                    <div class="date-outer">
                                        <div class="month"><?php echo get_the_date('M'); ?></div>
                                        <div class="date"><?php echo get_the_date('d'); ?></div>
                                    </div>
                                    <h3><a href="<?php echo esc_url( the_permalink( get_the_id() ) );?>"><?php the_title(); ?></a></h3>
                                    <div class="text"><?php echo wp_kses( wp_trim_words( get_the_content(), $settings['text_limits'] ), true); ?></div>
                                    <ul class="post-meta">
                                        <li><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><span class="icon flaticon-chat-comment-oval-speech-bubble-with-text-lines"></span><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></li>
                                        <li class="custom-category"><span class="icon far fa-folder-open"></span><?php the_category(', '); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- End News Section -->
        
        <?php }

        wp_reset_postdata();
    }
}
