<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Gallery_Projects extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_our_gallery_projects';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Gallery Projects', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'our_gallery_projects',
            [
                'label' => esc_html__( 'Our Gallery Projects', 'savelife' ),
            ]
        );
		$this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'number',
            [
                'label'   => esc_html__( 'Number of post', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 6,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'cat_exclude',
            [
                'label'       => esc_html__( 'Exclude', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
                'description' => esc_html__( 'Exclude categories, etc. by ID with comma separated.', 'savelife' ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'savelife' ),
                    'ASC'  => esc_html__( 'ASC', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'savelife' ),
                    'title'      => esc_html__( 'Title', 'savelife' ),
                    'menu_order' => esc_html__( 'Menu Order', 'savelife' ),
                    'rand'       => esc_html__( 'Random', 'savelife' ),
                ),
            ]
        );
		$this->add_control(
            'btn_title',
            [
                'label'       => __( 'Button Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Button Url', 'savelife' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'savelife' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->end_controls_section();

    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = get_query_var('paged');
        $paged = savelife_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-fixkar' );
        $args = array(
            'post_type'      => 'savelife_project',
            'posts_per_page' => savelife_set( $settings, 'number' ),
            'orderby'        => savelife_set( $settings, 'query_orderby' ),
            'order'          => savelife_set( $settings, 'query_order' ),
            'paged'         => $paged
        );
        $terms_array = explode(",",savelife_set( $settings, 'cat_exclude' ));
        if(savelife_set( $settings, 'cat_exclude' )) $args['tax_query'] = array(array('taxonomy' => 'project_cat','field' => 'id','terms' => $terms_array,'operator' => 'NOT IN',));
        $allowed_tags = wp_kses_allowed_html('post');
        $query = new \WP_Query( $args );
        $t = '';
        $data_filtration = '';
        $data_posts = '';
        if ( $query->have_posts() )
        {
            ob_start(); ?>

            <?php $count = 0;
            $fliteration = array();
            while( $query->have_posts() ): $query->the_post();
                global  $post;
                $meta = ''; //printr($meta);
                $meta1 = ''; //_WSH()->get_meta();
                $post_terms = get_the_terms( get_the_id(), 'project_cat');
                foreach( (array)$post_terms as $pos_term ) $fliteration[$pos_term->term_id] = $pos_term;
                $temp_category = get_the_term_list(get_the_id(), 'project_cat', '', ', ');

                $post_terms = wp_get_post_terms( get_the_id(), 'project_cat');
                $term_slug = '';
                if( $post_terms ) foreach( $post_terms as $p_term ) $term_slug .= $p_term->slug.' ';

                $term_list = wp_get_post_terms(get_the_id(), 'project_cat', array("fields" => "names"));

                $post_thumbnail_id = get_post_thumbnail_id($post->ID);
                $post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id); ?>
                
                <!-- Gallery Block -->
                <div class="gallery-block mix col-lg-4 col-md-6 col-sm-12 <?php echo esc_attr($term_slug); ?>">
                    <div class="inner-box">
                        <div class="image">
                            <?php the_post_thumbnail('savelife_370x485'); ?>
                            <div class="overlay-box">
                                <a href="<?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), false, '' ); echo $src[0]; ?>" data-fancybox="gallery" data-caption="" class="search-icon"><span class="icon flaticon-search"></span></a>
                                <div class="content">
                                    <h4><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h4>
                                    <div class="category">Volunteer</div>
                                </div>
                                <a href="<?php echo esc_url(get_permalink(get_the_id())); ?>" class="arrow flaticon-right-arrow-1"></a>
                            </div>
                        </div>
                    </div>
                </div>
                
            <?php endwhile;?>

            <?php wp_reset_postdata();
            $data_posts = ob_get_contents();
            ob_end_clean();

            ob_start();?>

            <?php $terms = get_terms(array('project_cat')); ?>
            
            <!-- Gallery Section -->
            <section class="gallery-section">
                <div class="auto-container">
                    <!-- Sec Title -->
                    <div class="sec-title centered">
                        <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                        <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                    </div>
                    
                    <!--MixitUp Galery-->
                    <div class="mixitup-gallery">
                        <!--Filter-->
                        <div class="filters clearfix">
                            <ul class="filter-tabs filter-btns text-center clearfix">
                                <li class="active filter" data-role="button" data-filter="all"><?php esc_attr_e('All', 'savelife');?></li>
                                <?php foreach( $fliteration as $t ): ?>
                                <li class="filter" data-role="button" data-filter=".<?php echo esc_attr(savelife_set( $t, 'slug' )); ?>"><?php echo wp_kses(savelife_set( $t, 'name' ), true); ?></li>
                                <?php endforeach;?>
                            </ul>
                        </div>
                        
                        <div class="filter-list row clearfix">
                            <?php echo wp_kses($data_posts, $allowed_tags); ?>
                        </div>
                    </div>
                    
                    <?php if($settings['btn_link']['url'] and $settings['btn_title']) { ?>
                    <div class="load-more-btn text-center">
                        <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="theme-btn btn-style-three"><span class="txt"><?php echo wp_kses( $settings['btn_title'], true ); ?></span></a>
                    </div>
                    <?php } ?>
                </div>
            </section>
            <!-- End Gallery Section -->
            
        <?php }
    }

}
