<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class How_We_Are extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_how_we_are';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'How We Are', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'how_we_are',
            [
                'label' => esc_html__( 'How We Are', 'savelife' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'slides',
            [
                'label'   => esc_html__( 'How We Are', 'savelife' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'savelife'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
						[
                            'name' => 'image',
                            'label' => esc_html__('Image', 'savelife'),
                            'type' => Controls_Manager::MEDIA,
							'default' => ['url' => Utils::get_placeholder_image_src(),],
                        ],
						[
                            'name' => 'text',
                            'label' => esc_html__('Text', 'savelife'),
                            'type' => Controls_Manager::TEXTAREA,
                        ],
						[
                            'name' => 'btn_title',
                            'label' => esc_html__('Button Title', 'medicoz'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
                        [
                            'name' => 'btn_link',
                            'label' => esc_html__('Button URL', 'medicoz'),
                            'type' => Controls_Manager::URL,
                            'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                            'show_external' => true,
                            'default' => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
		
		$this->start_controls_section(
            'most_urgent_cause',
            [
                'label' => esc_html__( 'Most Urgent Cause', 'savelife' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		
		$this->add_control(
            'c_subtitle',
            [
                'label'       => __( 'Sub Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'c_title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'collection',
            [
                'label'       => __( 'Raised Amount', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'donor',
            [
                'label'       => __( 'Donars', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'target',
            [
                'label'       => __( 'Goal Amount', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'datastart',
            [
                'label'       => __( 'Data Start', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'datastop',
            [
                'label'       => __( 'Data Stop', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'c_btn_title',
            [
                'label'       => __( 'Button Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'ext_url',
            [
                'label' => __( 'Button URL', 'savelife' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'savelife' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!--Default Section-->
        <section class="default-section">
            <div class="auto-container">
                <div class="row clearfix">
                    
                    <!--Column-->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <div class="sec-title">
                            <h2><?php echo wp_kses($settings['title'], true); ?></h2>
                        </div>
                        <div class="row clearfix">
                        	<?php foreach($settings['slides'] as $key => $item) { ?>
                            <!--We Are Block-->
                            <div class="we-are-block col-lg-6 col-md-6 col-sm-12">
                                <div class="inner-box">
                                    <div class="image">
                                        <img src="<?php echo esc_url(wp_get_attachment_url($item['image']['id'])); ?>" alt="<?php esc_html_e('Awesome Image', 'savelife'); ?>" />
                                    </div>
                                    <h3><a href="<?php echo esc_url($item['btn_link']['url']); ?>"><?php echo wp_kses($item['title'], true); ?></a></h3>
                                    <div class="text"><?php echo wp_kses($item['text'], true); ?></div>
                                    <a href="<?php echo esc_url($item['btn_link']['url']); ?>" class="read-more"><?php echo wp_kses($item['btn_title'], true); ?></a>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    
                    <!--Column-->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <div class="sec-title">
                            <h2><?php echo wp_kses( $settings[ 'c_subtitle' ], true );?></h2>
                        </div>
                        <!--Donate Box-->
                        <div class="donate-box">
                            <div class="inner-box">
                                <h2><?php echo wp_kses( $settings[ 'c_title' ], true );?></h2>
                                <div class="row clearfix">
                                    <div class="column col-lg-4 col-md-4 col-sm-12">
                                        <div class="title"><?php esc_html_e( 'Collected', 'savelife' );?></div>
                                        <h3><?php echo wp_kses( $settings[ 'collection' ], true );?></h3>
                                    </div>
                                    <div class="column col-lg-4 col-md-4 col-sm-12">
                                        <div class="title"><?php esc_html_e( 'Donators', 'savelife' );?></div>
                                        <h3><?php echo wp_kses( $settings[ 'donor' ], true );?></h3>
                                    </div>
                                    <div class="column col-lg-4 col-md-4 col-sm-12">
                                        <div class="title"><?php esc_html_e( 'Needed', 'savelife' );?></div>
                                        <h3><?php echo wp_kses( $settings[ 'target' ], true );?></h3>
                                    </div>
                                </div>
                                
                                <!--Donates-->
                                <div class="donates">
                                    <!--Donate Item-->
                                    <div class="donate-item">
                                        <div class="donated-bar">
                                            <div class="bar-inner"><div class="bar progress-line" data-width="<?php echo esc_attr( $settings[ 'datastop' ] );?>"></div></div>
                                        </div>
                                        <div class="donate-header clearfix">
                                            <div class="donated-percentage"><div class="count-box"><span class="count-text" data-speed="2000" data-stop="<?php echo esc_attr( $settings[ 'datastop' ] );?>"><?php echo esc_attr( $settings[ 'datastart' ] );?></span>%</div></div>
                                        </div>
                                    </div>
                                    <div class="clearfix donate-percent">
                                        <div class="pull-left number"><?php esc_html_e( '00', 'savelife' );?></div>
                                        <div class="pull-right number"><?php echo wp_kses( $settings[ 'collection' ], true );?></div>
                                    </div>
                                    <div class="clearfix">
                                        <div class="pull-left collected"><?php esc_html_e( 'Collected', 'savelife' );?> <span class="theme_color"><?php echo wp_kses( $settings[ 'collection' ], true );?></span></div>
                                        <?php if($settings[ 'c_btn_title' ]):?>
                                        <div class="pull-right"><a href="<?php echo esc_url( $settings[ 'ext_url' ][ 'url' ] ); ?>" class="theme-btn btn-style-three"><span class="txt"><?php echo wp_kses( $settings[ 'c_btn_title' ], true );?></span></a></div>
                                    	<?php endif;?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        <!--End Default Section-->
        
        <?php
    }
}
