<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Events extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_events';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Events', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'events',
            [
                'label' => esc_html__( 'Events', 'savelife' ),
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 450,
                'min'     => 1,
                'max'     => 1000,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 10,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'savelife'),
                'options' => get_categories_list('tribe_events_cat')
            ]
        );
        $this->end_controls_section();
		
		$this->start_controls_section(
            'events_sidebar_tab',
            [
                'label' => esc_html__( 'Events Sidebar', 'medicoz' ),
            ]
        );
        $this->add_control(
			'events_sidebar',
			[
				'label'   => esc_html__( 'Choose Sidebar', 'manzil' ),
				'separate' => 'before',
				'type'    => Controls_Manager::SELECT,
				'default' => 'Choose Sidebar',
				'options'  => savelife_get_sidebars(),
			]
		);
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $count = 1;
		$events = tribe_get_events(array(
			'posts_per_page' => $settings['query_number'],
			'tax_query'=> array(
				array(
					'taxonomy' => 'tribe_events_cat',
					'field' => 'slug',
					'terms' => $settings['query_category']
				)
			)
		)); ?>
        
        <!--Sidebar Page Container-->
        <div class="sidebar-page-container">
            <div class="auto-container">
                <div class="row clearfix">
                    
                    <!--Content Side-->
                    <div class="content-side col-lg-8 col-md-12 col-sm-12">
                        <?php 
							if ( empty( $events ) ) :
							echo 'Sorry, nothing found.';
							else: 
							foreach( $events as $event ) : 
							
							$event_thumbnail_id = get_post_thumbnail_id($event->ID);
							$event_thumbnail_url = wp_get_attachment_url($event_thumbnail_id);
							
							$start_datetime = tribe_get_start_date( $event->ID );
							$end_datetime = tribe_get_end_date( $event->ID );
							
							$start_date = tribe_get_start_date($event->ID, null, false, 'd' );
							$end_date = tribe_get_end_date($event->ID, null, false, 'd M, Y' );
							
							$start_time = tribe_get_start_time ( $event->ID, 'h:i A' );
							$end_time = tribe_get_end_time ( $event->ID, 'h:i A' );
							
							$location = get_option('location');
						?>
                        <!-- Event Block -->
                        <div class="event-block-two">
                            <div class="inner-box">
                                <div class="date"><strong><?php echo get_the_date('d'); ?></strong> <?php echo get_the_date('M'); ?></div>
                                <h4><a href="<?php echo esc_url(get_permalink($event->ID)); ?>"><?php echo wp_kses(get_the_title( $event->ID ), true);?></a></h4>
                                <ul class="info">
                                    <li><i class="flaticon-stopwatch-1"></i> <?php esc_html_e('at', 'savelife');?> <?php echo wp_kses($start_time, true); ?> - <?php echo wp_kses($end_time, true); ?></li>
                                    <li><i class="flaticon-placeholder-filled-point"></i> <?php echo tribe_get_venue( $event->ID ); ?></li>
                                </ul>
                                <div class="text"><?php echo wp_kses( wp_trim_words( get_the_content(), $settings['text_limit'] ), true ); ?></div>
                            </div>
                        </div>
                        <?php endforeach; endif; ?>
                        
                        <!-- Post Share Options -->
                        <div class="styled-pagination text-center">
                        	
                        </div>
                    </div>
                    
                    <?php if(is_active_sidebar($settings['events_sidebar'])) { ?>
                    <!--Sidebar Side-->
                    <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                        <aside class="sidebar sticky-top">
                            <?php dynamic_sidebar( $settings['events_sidebar'] ); ?>
                        </aside>
                    </div>
                	<?php } ?>
                </div>
            </div>
        </div>
                
        <?php
    }
}
   