<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Donation_Services extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_donation_services';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Donation Services', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'donation_services',
            [
                'label' => esc_html__( 'Donation Services', 'savelife' ),
            ]
        );
		$this->add_control(
            'slides',
            [
                'label'   => esc_html__( 'Donation Services', 'savelife' ),
                'type' => Controls_Manager::REPEATER,
				'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'image',
                            'label' => __( 'Image', 'savelife' ),
							'type' => Controls_Manager::MEDIA,
							'default' => ['url' => Utils::get_placeholder_image_src(),],
                        ],
						[
                            'name' => 'title',
                            'label' => esc_html__('Title', 'savelife'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
						[
                            'name' => 'text',
                            'label' => esc_html__('Text', 'savelife'),
                            'type' => Controls_Manager::TEXTAREA,
							'label_block' => true,
                        ],
						[
                            'name' => 'url',
                            'label' => esc_html__('URL', 'savelife'),
                            'type' => Controls_Manager::TEXT,
							'label_block' => true,
                        ],
						[
                            'name' => 'icon',
                            'label' => esc_html__('Select Icon', 'savelife'),
                            'type' => Controls_Manager::SELECT2,
                            'options' => get_fontawesome_icons(),
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!--Services Section-->
        <section class="updated-services-section">
            <div class="auto-container">
                
                <div class="row clearfix">
                
                    <!-- Services Style One -->
                    <?php foreach($settings['slides'] as $key => $item) { ?>
                    <div class="updated-services-style-one col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-box" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($item['image']['id'])); ?>);">
                            <div class="icon-box"><span class="icon <?php echo esc_attr($item['icon']); ?>"></span></div>
                            <h3><a href="<?php echo esc_url( $item['url'] ); ?>"><?php echo wp_kses($item['title'], true); ?></a></h3>
                            <div class="text"><?php echo wp_kses($item['text'], true); ?></div>
                            <div class="arrow-box"><a href="<?php echo esc_url( $item['url'] ); ?>" class="arow flaticon-right-arrow"></a></div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                
            </div>
        </section>
        <!--End Services Section-->
        
        <?php
    }
}
