<?php
$options = savelife_WSH()->option(); 
$allowed_html = wp_kses_allowed_html( 'post' );

//Logo Settings
$image_logo = $options->get( 'logo_v2' );
$logo_dimension = $options->get( 'logo_dimension_v2' );

$mobile_logo = $options->get( 'mobile_logo_v1' );
$mobile_logo_dimension = $options->get( 'mobile_logo_dimension_v1' );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

	<?php if( $options->get( 'theme_preloader' ) ):?>
    <!-- Preloader -->
    <div class="preloader"></div>
	<?php endif; ?>
    <!-- Main Header -->
    <header class="main-header header-style-five">
        <!--Header-Upper-->
        <div class="header-upper">
            <div class="auto-container">
                <div class="clearfix">
                    
                    <div class="pull-left logo-box">
                        <div class="logo">
                            <?php echo savelife_logo( $logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography ); ?>
                        </div>
                    </div>
                    
                    <div class="pull-right upper-right clearfix">
                        
                        <!-- Info Box -->
                        <?php if( $options->get('email_switcher_v6') ):?>
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="flaticon-message"></span></div>
                            <ul>
                                <li><a href="mailto:<?php echo esc_url( $options->get( 'email_v6' ) );?>"><?php echo sanitize_email( $options->get( 'email_v6' ) );?></a></li>
                                <li><strong><?php esc_html_e( 'Mail to us', 'savelife' );?></strong></li>
                            </ul>
                        </div>
                        <?php endif;?>
                        <!-- Info Box -->
                        <?php if( $options->get('address_switcher_v6') ):?>
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="flaticon-location"></span></div>
                            <ul>
                                <li><?php echo wp_kses( $options->get('address_v6'), true );?></li>
                                <li><strong><?php esc_html_e( 'Address', 'savelife' );?></strong></li>
                            </ul>
                        </div>
                        <?php endif;?>
                        
                        <!-- Info Box -->
                        <?php if( $options->get('phone_switcher_v6') ):?>
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="flaticon-call"></span></div>
                            <ul>
                                <li><?php echo wp_kses( $options->get('phone_v6'), true );?></li>
                                <li><strong><?php esc_html_e( 'Call For Help', 'savelife' );?></strong></li>
                            </ul>
                        </div>
                        <?php endif;?>
                        
                    </div>
                    
                </div>
            </div>
        </div>
        <!--End Header Upper-->
        
        <!--Header Lower-->
        <div class="header-lower">
            
            <div class="auto-container">
                <div class="nav-outer clearfix">
                    <!-- Mobile Navigation Toggler -->
                    <div class="mobile-nav-toggler"><span class="icon flaticon-menu-2"></span></div>
                    <!-- Main Menu -->
                    <nav class="main-menu show navbar-expand-md">
                        <div class="navbar-header">
                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                            </button>
                        </div>
                        
                        <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                            <ul class="navigation clearfix">
                                <?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                    'container_class'=>'navbar-collapse collapse navbar-right',
                                    'menu_class'=>'nav navbar-nav',
                                    'fallback_cb'=>false, 
                                    'items_wrap' => '%3$s', 
                                    'container'=>false,
                                    'depth'=>'3',
                                    'walker'=> new Bootstrap_walker()  
                                ) ); ?>
                            </ul>
                        </div>
                    </nav>
                    <!-- Main Menu End-->
        
                    <!-- Options Box -->
                    <div class="options-box clearfix">
                        
                        <!-- Search Box -->
                        <?php if( $options->get('search_v6') ):?>
                        <div class="search-box-outer">
                            <div class="search-box-btn"><span class="fa fa-search"></span></div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if( $options->get('social_profile_switcher_v6') ):
                        $icons = $options->get( 'social_profile_v6' );
                        if ( ! empty( $icons ) ) : ?>
                        <div class="social-box">
                            <!--Social Box-->
                            <ul class="social-icons">
                                <?php foreach ( $icons as $h_icon ) :
                                    $header_social_icons = json_decode( urldecode( savelife_set( $h_icon, 'data' ) ) );
                                    if ( savelife_set( $header_social_icons, 'enable' ) == '' ) {
                                        continue;
                                    }
                                    $icon_class = explode( '-', savelife_set( $header_social_icons, 'icon' ) ); ?>
                                    <li><a href="<?php echo esc_url(savelife_set( $header_social_icons, 'url' )); ?>" style="background-color:<?php echo esc_attr(savelife_set( $header_social_icons, 'background' )); ?>; color: <?php echo esc_attr(savelife_set( $header_social_icons, 'color' )); ?>" class="fab <?php echo esc_attr( savelife_set( $header_social_icons, 'icon' ) ); ?>"></a></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <?php endif; endif; ?>
                        
                    </div>
                    
                </div>
            </div>
        </div>
        <!-- End Header Lower -->
        
        <!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon flaticon-multiply"></span></div>
            
            <nav class="menu-box">
                <div class="nav-logo">
                    <?php echo savelife_logo( $logo_type, $mobile_logo, $mobile_logo_dimension, $logo_text, $logo_typography ); ?>
                </div>
                <div class="menu-outer">
                    <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                </div>
            </nav>
        </div>
        <!-- End Mobile Menu -->
    
    </header>
    <!-- End Main Header -->
    
    <?php if( $options->get('search_v6') ):?>
    
    <!-- Header Search -->
    <div class="search-popup">
        <button class="close-search style-two"><span class="flaticon-plus"></span></button>
        <button class="close-search"><span class="flaticon-plus"></span></button>
        <?php get_template_part('searchform1'); ?>
    </div>
    <!-- End Header Search -->
    <!-- xs modal -->
    <div class="zoom-anim-dialog mfp-hide modal-searchPanel" id="modal-popup-2">
        <div class="xs-search-panel">
            <?php get_template_part('searchform1'); ?>
        </div>
    </div><!-- End xs modal -->
    <?php endif; ?>