<?php
/**
 * Footer Template  File
 *
 * @package SAVELIFE
 * @author  Theme Kalia
 * @version 1.0
 */

$options = savelife_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );
?>
	
    <?php if($options->get('footer_top_switcher_v1') or $options->get('footer_bottom_switcher_v1')) { ?>
	<!-- Main Footer -->
	<footer class="main-footer" style="background-image:url(<?php echo get_template_directory_uri(); ?>/assets/images/background/map-pattern.png)">
        <?php if( $options->get('footer_top_switcher_v1') ):?>
		<!-- Upper Section -->
		<div class="upper-section">
			<div class="row clearfix">
				<?php if($options->get('footer_email_v1') and $options->get('footer_email_text_v1')) { ?>
				<!-- Info Block -->
				<div class="info-block col-lg-4 col-md-6 col-sm-12">
					<div class="block-inner" style="background-image:url(<?php echo get_template_directory_uri(); ?>/assets/images/background/pattern-1.png)">
						<div class="content">
							<div class="icon flaticon-message-1"></div>
							<h4><a href="mailto:<?php echo wp_kses( $options->get('footer_email_v1'), $allowed_html); ?>"><?php echo wp_kses( $options->get('footer_email_v1'), $allowed_html); ?></a></h4>
							<div class="title"><?php echo wp_kses( $options->get('footer_email_text_v1'), $allowed_html); ?></div>
						</div>
					</div>
				</div>
                <?php } ?>
                
                <?php if($options->get('footer_phone_v1') and $options->get('footer_phone_text_v1')) { ?>
				<!-- Info Block -->
				<div class="info-block col-lg-4 col-md-6 col-sm-12">
					<div class="block-inner" style="background-image:url(<?php echo get_template_directory_uri(); ?>/assets/images/background/pattern-1.png)">
						<div class="content">
							<div class="icon flaticon-telephone"></div>
							<h4><a href="tel:<?php echo phone_number($options->get('footer_phone_v1')); ?>"><?php echo wp_kses( $options->get('footer_phone_v1'), $allowed_html); ?></a></h4>
							<div class="title"><?php echo wp_kses( $options->get('footer_phone_text_v1'), $allowed_html); ?></div>
						</div>
					</div>
				</div>
                <?php } ?>
				
                <?php if($options->get('footer_address_v1') and $options->get('footer_address_text_v1')) { ?>
				<!-- Info Block -->
				<div class="info-block col-lg-4 col-md-6 col-sm-12">
					<div class="block-inner" style="background-image:url(<?php echo get_template_directory_uri(); ?>/assets/images/background/pattern-1.png)">
						<div class="content">
							<div class="icon flaticon-placeholder-filled-point"></div>
							<h4><?php echo wp_kses( $options->get('footer_address_v1'), $allowed_html); ?></h4>
                            <div class="title"><?php echo wp_kses( $options->get('footer_address_text_v1'), $allowed_html); ?></div>
						</div>
					</div>
				</div>
                <?php } ?>
			</div>
		</div>
		<?php endif; ?>
		
        <?php if ( is_active_sidebar( 'footer-sidebar' ) ) { ?>
		<div class="auto-container">
			<!--Widgets Section-->
            <div class="widgets-section">
            	<div class="row clearfix">
                	<?php dynamic_sidebar( 'footer-sidebar' ); ?>
				</div>
			</div>
		</div>
        <?php } ?>
		
        <?php if( $options->get('footer_bottom_switcher_v1') ):?>
		<!-- Footer Bottom -->
		<div class="footer-bottom-two">
			<div class="auto-container">
				<div class="clearfix">
                	
					<div class="pull-left">
						<div class="copyright"><?php echo wp_kses( $options->get( 'copyrights' ), $allowed_html); ?></div>
					</div>
                    
					<div class="pull-right">
						<ul class="footer-nav">
							<?php wp_nav_menu( array( 'theme_location' => 'footer_menu', 'container_id' => 'navbar-collapse-1',
								'container_class'=>'navbar-collapse collapse navbar-right',
								'menu_class'=>'nav navbar-nav',
								'fallback_cb'=>false, 
								'items_wrap' => '%3$s', 
								'container'=>false,
								'depth'=>'3',
								'walker'=> new Bootstrap_walker()  
							) ); ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
		<?php endif; ?>
	</footer>
	<!-- End Main Footer -->
    <?php } ?>
    
</div>
<!--End pagewrapper-->

<!--Scroll to top-->
<div class="scroll-to-top scroll-to-target" data-target="html"><span class="fa fa-arrow-up"></span></div>