<?php get_header(); 
$data = \SAVELIFE\Includes\Classes\Common::instance()->data( 'single-savelife_project' )->get();

$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
$options = savelife_WSH()->option();

do_action( 'savelife_banner', $data );
$allowed_tags = wp_kses_allowed_html('post'); ?>

<?php while( have_posts() ) : the_post(); ?>

<!--Page Title-->
<section class="page-title" style="background-image:url(<?php echo esc_url( $data->get( 'banner' ) ); ?>);">
    <div class="auto-container">
        <div class="content-box clearfix">
            <!--Title -->
            <div class="title-column">
                <h1><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h1>
            </div>
            <!--Bread Crumb -->
            <div class="breadcrumb-column">
                <ul class="bread-crumb clearfix">
                    <?php echo savelife_the_breadcrumb(); ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<!--End Page Title-->

<!--Sidebar Page Container-->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
            
            <?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'savelife_sidebar', $data );
				}
			?>
            
            <!--Content Side-->
            <div class="content-side <?php echo esc_attr( $class ); ?>">
                <div class="event-single project-detail-section">
                    <div class="inner-box">
                    	<?php $main_image = get_post_meta(get_the_id(), 'main_image', true);
						if($main_image) { ?>
                        <div class="image">
                            <img src="<?php echo wp_get_attachment_url($main_image['id']); ?>" alt="<?php esc_html_e('Awesome Image', 'savelife'); ?>" />
                            <div class="post-date"><?php echo get_the_date(); ?></div>
                        </div>
                        <?php } ?>
                        
                        <div class="lower-content">
                            <h2><?php the_title(); ?></h2>
                            <?php the_content(); ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'savelife_sidebar', $data );
				}
			?>
        </div>
    </div>
</div>

<?php endwhile; ?>

<?php get_footer(); ?>