<?php
/**
 * Single Event Template
 * A single event. This displays the event title, description, meta, and
 * optionally, the Google map for the event.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/single-event.php
 *
 * @package TribeEventsCalendar
 * @version 4.2.4
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}
global $post;
$event_id = get_the_ID();

$data    = \SAVELIFE\Includes\Classes\Common::instance()->data( 'single' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
$layout = ( $layout ) ? $layout : 'right';
$sidebar = ( $sidebar ) ? $sidebar : 'blog-sidebar';
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
$options = savelife_WSH()->option();


$event_thumbnail_id = get_post_thumbnail_id($event_id);
$event_thumbnail_url = wp_get_attachment_url($event_thumbnail_id);

$start_datetime = tribe_get_start_date( $event_id );
$end_datetime = tribe_get_end_date( $event_id );

$start_date = tribe_get_start_date($event_id, null, false, 'd' );
$end_date = tribe_get_end_date($event_id, null, false, 'd M, Y' );

$start_time = tribe_get_start_time ( $event_id, 'h:i A' );
$end_time = tribe_get_end_time ( $event_id, 'h:i A' );

$location = get_option('location');

?>

<!--Page Title-->
<section class="page-title" style="background-image:url(<?php echo esc_url( $data->get( 'banner' ) ); ?>);">
    <div class="auto-container">
        <div class="content-box clearfix">
            <!--Title -->
            <div class="title-column">
                <h1><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h1>
            </div>
            <!--Bread Crumb -->
            <div class="breadcrumb-column">
                <ul class="bread-crumb clearfix">
                    <?php echo savelife_the_breadcrumb(); ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<!--End Page Title-->

<!--Sidebar Page Container-->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
        	
            <!-- sidebar area -->
			<?php if( $layout == 'left' ): ?>
                <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar sticky-top">
                        <?php dynamic_sidebar( $sidebar ); ?>
                    </aside>
                </div>
			<?php endif; ?>
            
            <div class="content-side <?php echo esc_attr( $class ); ?>">
                <div class="event-single">
					<?php while ( have_posts() ) : the_post(); ?>
                    <div class="inner-box">
                        <div class="image">
                            <?php echo tribe_event_featured_image( $event_id, 'full', false ); ?>
                            <div class="post-date"><?php the_date(); ?></div>
                        </div>
                        <div class="lower-content">
                            <h2><?php the_title(); ?></h2>
                            <ul class="post-info clearfix">
                                <li class="clock"><span class="icon fa fa-clock"></span><?php esc_html_e('at', 'savelife');?> <?php echo wp_kses($start_time, true); ?> - <?php echo wp_kses($end_time, true); ?></li>
                                <li><span class="icon fa fa-map-marker"></span><?php echo tribe_get_venue( $event_id ); ?></li>
                                <li class="social"><?php esc_html_e('Share:', 'savelife'); ?> 
                                    <a href="http://www.facebook.com/sharer.php?u=<?php echo esc_url(get_permalink($event_id)); ?>" target="_blank" class="fab fa-facebook"></a>
                                    <a href="http://www.linkedin.com/shareArticle?url=<?php echo esc_url(get_permalink($event_id)); ?>&title=<?php echo esc_attr($post->post_name); ?>" target="_blank" class="fab fa-linkedin"></a>
                                    <a href="https://twitter.com/share?url=<?php echo esc_url(get_permalink($event_id)); ?>&text=<?php echo esc_attr($post->post_name); ?>" target="_blank" class="fab fa-twitter"></a>
                                    <a href="https://pinterest.com/pin/create/bookmarklet/?url=<?php echo esc_url(get_permalink($event_id)); ?>&description=<?php echo esc_attr($post->post_name); ?>" target="_blank" class="fab fa-pinterest-p"></a>
                                </li>
                            </ul>
                            <?php the_content(); ?>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        	
            <!-- sidebar area -->
			<?php if( $layout == 'right' ): ?>
                <div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar sticky-top">
                        <?php dynamic_sidebar( $sidebar ); ?>
                    </aside>
                </div>
			<?php endif; ?>
			
        </div>
    </div>
</div>
<!--End blog area-->
