<?php
$options = savelife_WSH()->option();
$allowed_html = wp_kses_allowed_html( 'post' );

//Logo Settings
$image_logo = $options->get( 'logo_v3' );
$logo_dimension = $options->get( 'logo_dimension_v3' );

$mobile_logo = $options->get( 'mobile_logo_v3' );
$mobile_logo_dimension = $options->get( 'mobile_logo_dimension_v3' );

$sidebar_logo = $options->get( 'sidebar_logo_v3' );
$sidebar_logo_dimension = $options->get( 'sidebar_logo_dimension_v3' );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

	<?php if( $options->get( 'theme_preloader' ) ):?>
    <!-- Preloader -->
    <div class="preloader"></div>
	<?php endif; ?>
    
    <!-- Main Header / Header Style Three-->
    <header class="main-header header-style-three">
    	
    	<!-- Header Upper-->
        <div class="header-upper">
        	<div class="auto-container">
            	<div class="inner-container clearfix">
                	
                	<div class="pull-left logo-box">
                    	<div class="logo"><?php echo savelife_logo( $logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography ); ?></div>
                    </div>
                    
                    <div class="nav-outer clearfix">
						<!-- Mobile Navigation Toggler -->
						<div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
						
						<!-- Main Menu -->
						<nav class="main-menu navbar-expand-md">
							<div class="navbar-header">
								<!-- Toggle Button -->    	
								<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
									<span class="icon-bar"></span>
								</button>
							</div>
							
							<div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
								<ul class="navigation clearfix">
									<?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                        'container_class'=>'navbar-collapse collapse navbar-right',
                                        'menu_class'=>'nav navbar-nav',
                                        'fallback_cb'=>false, 
                                        'items_wrap' => '%3$s', 
                                        'container'=>false,
                                        'depth'=>'3',
                                        'walker'=> new Bootstrap_walker()  
                                    ) ); ?>
								</ul>
							</div>
						</nav>
						
                        <?php if( $options->get('sidebar_info_v3') ):?>
						<!-- Main Menu End-->
						<div class="outer-box clearfix">
							<div class="btn-box">

								<!-- Main Menu End-->
								<div class="nav-box">
									<div class="nav-btn nav-toggler navSidebar-button"><span class="icon flaticon-menu-1"></span></div>
								</div>
							</div>
						</div>
						<?php endif; ?>
					</div>
                </div>
            </div>
        </div>
        <!--End Header Upper-->
        
		<!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon fa fa-window-close"></span></div>
            
            <nav class="menu-box">
                <div class="nav-logo"><?php echo savelife_logo( $logo_type, $mobile_logo, $mobile_logo_dimension, $logo_text, $logo_typography ); ?></div>
                <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
            </nav>
        </div>
		<!-- End Mobile Menu -->
    
    </header>
    <!--End Main Header -->
    
    <?php if( $options->get('sidebar_info_v2') ):?>
    <!-- sidebar cart item -->
	<div class="xs-sidebar-group info-group">
		<div class="xs-overlay xs-bg-black"></div>
		<div class="xs-sidebar-widget">
			<div class="sidebar-widget-container">
				<div class="widget-heading">
					<a href="#" class="close-side-widget">X</a>
				</div>
				<div class="sidebar-textwidget">
					<!-- Sidebar Info Content -->
                    <div class="sidebar-info-contents">
                        <div class="content-inner">
                            <div class="logo">
                                <?php echo savelife_logo( $logo_type, $sidebar_logo, $sidebar_logo_dimension, $logo_text, $logo_typography ); ?>
                            </div>
                            <div class="content-box">
                                <?php if( $options->get('sidebar_title_v3') ):?>
                                <h2><?php echo wp_kses($options->get('sidebar_title_v3'), $allowed_html);?></h2>
                                <?php endif; ?>
                                
                                <?php if( $options->get('sidebar_text_v3') ):?>
                                <p class="text"><?php echo wp_kses($options->get('sidebar_text_v3'), $allowed_html);?></p>
                                <?php endif; ?>
                                
                                <?php if( $options->get('sidebar_button_switcher_v3') ):?>
                                <a href="<?php echo esc_url($options->get('sidebar_button_url_v3'));?>" class="theme-btn btn-style-three"><span class="txt"><?php echo wp_kses($options->get('sidebar_button_title_v3'), $allowed_html);?></span></a>
                                <?php endif; ?>
                            </div>
                            <div class="contact-info">
								<?php if( $options->get('sidebar_contact_info_title_v3') ):?>
                                <h2><?php echo wp_kses($options->get('sidebar_contact_info_title_v3'), $allowed_html);?></h2>
								<?php endif; ?>
                                
                                <ul class="list-style-two">
                                	<?php if( $options->get('sidebar_address_v3') ):?>
                                    <li><span class="icon flaticon-map-1"></span><?php echo wp_kses($options->get('sidebar_address_v3'), $allowed_html);?></li>
                                    <?php endif; ?>
                                    
                                	<?php if( $options->get('sidebar_email_v3') ):?>
                                    <li><span class="icon flaticon-telephone"></span><?php echo wp_kses($options->get('sidebar_email_v3'), $allowed_html);?></li>
                                    <?php endif; ?>
                                    
                                	<?php if( $options->get('sidebar_phone_no_v3') ):?>
                                    <li><span class="icon flaticon-message-1"></span><?php echo wp_kses($options->get('sidebar_phone_no_v3'), $allowed_html);?></li>
                                    <?php endif; ?>
                                    
                                	<?php if( $options->get('sidebar_working_hour_v3') ):?>
                                    <li><span class="icon flaticon-timetable"></span><?php echo wp_kses($options->get('sidebar_working_hour_v3'), $allowed_html);?></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            
                        	<?php $icons = $options->get( 'social_profile_switcher_v3' );
                        	if ( ! empty( $icons ) ) : ?>
                            <!-- Social Box -->
                            <ul class="social-box">
                            	<?php foreach ( $icons as $h_icon ) :
									$header_social_icons = json_decode( urldecode( savelife_set( $h_icon, 'data' ) ) );
									if ( savelife_set( $header_social_icons, 'enable' ) == '' ) {
										continue;
									}
									$icon_class = explode( '-', savelife_set( $header_social_icons, 'icon' ) ); ?>
									<li><a href="<?php echo esc_url(savelife_set( $header_social_icons, 'url' )); ?>" style="background-color:<?php echo esc_attr(savelife_set( $header_social_icons, 'background' )); ?>; color: <?php echo esc_attr(savelife_set( $header_social_icons, 'color' )); ?>" class="fab <?php echo esc_attr( savelife_set( $header_social_icons, 'icon' ) ); ?>" target="_blank"></a></li>
								<?php endforeach; ?>
                            </ul>
							<?php endif; ?>
                        </div>
                    </div>
					
				</div>
			</div>
		</div>
	</div>
	<!-- END sidebar widget item -->
    <?php endif; ?>
    