<?php

require_once get_template_directory() . '/includes/loader.php';

add_action( 'after_setup_theme', 'savelife_setup_theme' );
add_action( 'after_setup_theme', 'savelife_load_default_hooks' );


function savelife_setup_theme() {

	load_theme_textdomain( 'savelife', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );
	add_theme_support( 'custom-header' );
	add_theme_support( 'custom-background' );
	add_theme_support('woocommerce');
	add_theme_support('wc-product-gallery-lightbox');

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'editor-styles' );


	// Set the default content width.
	$GLOBALS['content_width'] = 525;
	
	/*---------- Register image sizes ----------*/
	
	//Register image sizes
	add_image_size( 'savelife_370x270', 370, 270, true ); //'Our Recent Causes & Causes V2'
	add_image_size( 'savelife_530x350', 530, 350, true ); //'Upcoming Events'
	add_image_size( 'savelife_570x350', 570, 350, true ); //'Our Latest News V1'
	add_image_size( 'savelife_370x485', 370, 485, true ); //'Our Gallery Projects'
	add_image_size( 'savelife_130x130', 130, 130, true ); //'Testimonials V1'
	add_image_size( 'savelife_350x230', 350, 230, true ); //'Our Latest News V2'
	add_image_size( 'savelife_90x90', 90, 90, true ); //'Testimonials V2 & V3'
	add_image_size( 'savelife_770x450', 770, 450, true ); //'Our Latest News V3 & Blog Single'
	add_image_size( 'savelife_80x80', 770, 450, true ); //'Footer Recent Post'
	
	/*---------- Register image sizes ends ----------*/
	
	
	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'main_menu' => esc_html__( 'Main Menu', 'savelife' ),
		'footer_menu' => esc_html__( 'Footer Menu', 'savelife' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'      => 250,
		'height'     => 250,
		'flex-width' => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style();
	add_action( 'admin_init', 'savelife_admin_init', 2000000 );
}

/**
 * [savelife_admin_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */


function savelife_admin_init() {
	remove_action( 'admin_notices', array( 'ReduxFramework', '_admin_notices' ), 99 );
}

/*---------- Sidebar settings ----------*/

/**
 * [savelife_widgets_init]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
function savelife_widgets_init() {

	global $wp_registered_sidebars;

	$theme_options = get_theme_mod( 'savelife' . '_options-mods' );

	register_sidebar( array(
		'name'          => esc_html__( 'Default Sidebar', 'savelife' ),
		'id'            => 'default-sidebar',
		'description'   => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'savelife' ),
		'before_widget' => '<div id="%1$s" class="widget sidebar-widget single-sidebar %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar(array(
		'name' => esc_html__('Footer Widget', 'savelife'),
		'id' => 'footer-sidebar',
		'description' => esc_html__('Widgets in this area will be shown in Footer Area.', 'savelife'),
		'before_widget'=>'<div class="col-lg-3 col-md-6 col-sm-12 footer-column"><div id="%1$s" class="footer-widget %2$s">',
		'after_widget'=>'</div></div>',
		'before_title' => '<h4>',
		'after_title' => '</h4>'
	));
	register_sidebar(array(
	  'name' => esc_html__( 'Blog Listing', 'savelife' ),
	  'id' => 'blog-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'savelife' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="sidebar-title"><h2>',
	  'after_title' => '</h2></div>'
	));
	if ( ! is_object( savelife_WSH() ) ) {
		return;
	}

	$sidebars = savelife_set( $theme_options, 'custom_sidebar_name' );

	foreach ( array_filter( (array) $sidebars ) as $sidebar ) {

		if ( savelife_set( $sidebar, 'topcopy' ) ) {
			continue;
		}

		$name = $sidebar;
		if ( ! $name ) {
			continue;
		}
		$slug = str_replace( ' ', '_', $name );

		register_sidebar( array(
			'name'          => $name,
			'id'            => sanitize_title( $slug ),
			'before_widget' => '<div id="%1$s" class="%2$s widget ">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}

	update_option( 'wp_registered_sidebars', $wp_registered_sidebars );
}

add_action( 'widgets_init', 'savelife_widgets_init' );

/*---------- Sidebar settings ends ----------*/

/*---------- Gutenberg settings ----------*/

function savelife_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong yellow', 'savelife' ),
            'slug' => 'strong-yellow',
            'color' => '#f7bd00',
        ),
        array(
            'name' => esc_html__( 'strong white', 'savelife' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'savelife' ),
            'slug' => 'light-black',
            'color' => '#242424',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'savelife' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'savelife' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );
	
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Small', 'savelife' ),
			'size' => 10,
			'slug' => 'small'
		),
		array(
			'name' => esc_html__( 'Normal', 'savelife' ),
			'size' => 15,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Large', 'savelife' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'savelife' ),
			'size' => 36,
			'slug' => 'huge'
		)
	) );
	
}
add_action( 'after_setup_theme', 'savelife_gutenberg_editor_palette_styles' );

/*---------- Gutenberg settings ends ----------*/

/*---------- Enqueue Styles and Scripts ----------*/

function savelife_enqueue_scripts() {
	
	//styles
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.css' );
	wp_enqueue_style( 'fontawesome-all', get_template_directory_uri() . '/assets/css/fontawesome-all.css' );
	//wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/css/font-awesome.css' );
	wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/assets/css/flaticon.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.css' );
	wp_enqueue_style( 'owl-theme', get_template_directory_uri() . '/assets/css/owl.css' );
	wp_enqueue_style( 'animation', get_template_directory_uri() . '/assets/css/animation.css' );
	wp_enqueue_style( 'jquery-ui', get_template_directory_uri() . '/assets/css/jquery-ui.css' );
	wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/assets/css/magnific-popup.css' );
	wp_enqueue_style( 'jquery-fancybox', get_template_directory_uri() . '/assets/css/jquery.fancybox.min.css' );
	wp_enqueue_style( 'jquery.bootstrap-touchspin', get_template_directory_uri() . '/assets/css/jquery.bootstrap-touchspin.css' );
	wp_enqueue_style( 'jquery.mCustomScrollbar.min', get_template_directory_uri() . '/assets/css/jquery.mCustomScrollbar.min.css' );
	wp_enqueue_style( 'savelife-main', get_stylesheet_uri() );
	wp_enqueue_style( 'savelife-main-style', get_template_directory_uri() . '/assets/css/style.css' );
	wp_enqueue_style( 'savelife-color-scheme', get_template_directory_uri() . '/assets/css/color-themes/default-theme.css' );
	wp_enqueue_style( 'savelife-custom', get_template_directory_uri() . '/assets/css/custom.css' );
	wp_enqueue_style( 'savelife-like', get_template_directory_uri() . '/assets/css/like.css' );
	wp_enqueue_style( 'savelife-woocommerce', get_template_directory_uri() . '/assets/css/woocommerce.css' );
	//wp_enqueue_style( 'savelife-tut', get_template_directory_uri() . '/assets/css/tut.css' );
	//wp_enqueue_style( 'savelife-gutenberg', get_template_directory_uri() . '/assets/css/gutenberg.css' );
	wp_enqueue_style( 'savelife-responsive', get_template_directory_uri() . '/assets/css/responsive.css' );
	
	
    //scripts
	wp_enqueue_script( 'jquery-ui-core');
	wp_enqueue_script( 'popper', get_template_directory_uri().'/assets/js/popper.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/assets/js/bootstrap.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery.mCustomScrollbar.concat.min', get_template_directory_uri().'/assets/js/jquery.mCustomScrollbar.concat.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-fancybox', get_template_directory_uri().'/assets/js/jquery.fancybox.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'appear', get_template_directory_uri().'/assets/js/appear.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'owl-theme', get_template_directory_uri().'/assets/js/owl.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'wow', get_template_directory_uri().'/assets/js/wow.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'mixitup', get_template_directory_uri().'/assets/js/mixitup.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'slick', get_template_directory_uri().'/assets/js/slick.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'knob', get_template_directory_uri().'/assets/js/knob.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery-ui', get_template_directory_uri().'/assets/js/jquery-ui.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery.countdown', get_template_directory_uri().'/assets/js/jquery.countdown.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'nav-tool', get_template_directory_uri().'/assets/js/nav-tool.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'jquery.magnific-popup.min', get_template_directory_uri().'/assets/js/jquery.magnific-popup.min.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'main', get_template_directory_uri().'/assets/js/main.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'savelife-like', get_template_directory_uri().'/assets/js/main.js', array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'savelife-main-script', get_template_directory_uri().'/assets/js/script.js', array(), false, true );
	if( is_singular() ) wp_enqueue_script('comment-reply');
}
add_action( 'wp_enqueue_scripts', 'savelife_enqueue_scripts' );

/*---------- Enqueue styles and scripts ends ----------*/

/*---------- Google fonts ----------*/

function savelife_fonts_url() {
	
	$fonts_url = '';

		$font_families['Josefin-Sans'] = 'Josefin Sans:300,400,600,700';
		$font_families['Muli'] = 'Muli:300,400,500,600,700,800,900';

		$font_families = apply_filters( 'SAVELIFE/includes/classes/header_enqueue/font_families', $font_families );

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$protocol  = is_ssl() ? 'https' : 'http';
		$fonts_url = add_query_arg( $query_args, $protocol . '://fonts.googleapis.com/css' );

		return esc_url_raw($fonts_url);

}

function savelife_theme_styles() {
    wp_enqueue_style( 'savelife-theme-fonts', savelife_fonts_url(), array(), null );
}

add_action( 'wp_enqueue_scripts', 'savelife_theme_styles' );
add_action( 'admin_enqueue_scripts', 'savelife_theme_styles' );

/*---------- Google fonts ends ----------*/

/*---------- More functions ----------*/

// 1) savelife_set function

/**
 * [savelife_set description]
 *
 * @param  array $data [description]
 *
 * @return [type]       [description]
 */
if ( ! function_exists( 'savelife_set' ) ) {
	function savelife_set( $var, $key, $def = '' ) {
		//if( ! $var ) return false;

		if ( is_object( $var ) && isset( $var->$key ) ) {
			return $var->$key;
		} elseif ( is_array( $var ) && isset( $var[ $key ] ) ) {
			return $var[ $key ];
		} elseif ( $def ) {
			return $def;
		} else {
			return false;
		}
	}
}

// 2) savelife_add_editor_styles function

function savelife_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'savelife_add_editor_styles' );

// 3) Add specific CSS class by filter body class.

$options = savelife_WSH()->option(); 
if( savelife_set($options, 'boxed_wrapper') ){

add_filter( 'body_class', function( $classes ) {
    $classes[] = 'boxed_wrapper';
    return $classes;
} );
}

// 4) savelife_related_products_limit function 

function savelife_related_products_limit() {
  global $product;
	
	$args['posts_per_page'] = 6;
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'savelife_related_products_args', 20 );
  function savelife_related_products_args( $args ) {
	$args['posts_per_page'] = 3; // 4 related products
	$args['columns'] = 1; // arranged in 2 columns
	return $args;
}

/*---------- More functions ends ----------*/