<?php
$options = savelife_WSH()->option(); 
$allowed_html = wp_kses_allowed_html( 'post' );

//Logo Settings
$image_logo = $options->get( 'logo_v1' );
$logo_dimension = $options->get( 'logo_dimension_v1' );

$mobile_logo = $options->get( 'mobile_logo_v1' );
$mobile_logo_dimension = $options->get( 'mobile_logo_dimension_v1' );

$sidebar_logo = $options->get( 'sidebar_logo_v1' );
$sidebar_logo_dimension = $options->get( 'sidebar_logo_dimension_v1' );

$logo_type = '';
$logo_text = '';
$logo_typography = ''; ?>

	<?php if( $options->get( 'theme_preloader' ) ):?>
    <!-- Preloader -->
    <div class="preloader"></div>
	<?php endif; ?>
    
    <!-- Main Header-->
    <header class="main-header header-style-one">
    	<?php if( $options->get('show_topbar_v1') ):?>
		<!--Header Top-->
    	<div class="header-top">
    		<div class="auto-container">
				<div class="row clearfix">
    				<?php if( $options->get('welcome_message_switcher_v1') ):?>
					<!--Top Left-->
					<div class="top-left col-lg-5 col-md-12 col-sm-12">
						<ul>
							<li><?php echo wp_kses($options->get('welcome_message_v1'), $allowed_html);?></li>
						</ul>
					</div>
                    <?php endif; ?>
					
					<!--Top Right-->
					<div class="top-right col-lg-7 col-md-12 col-sm-12">
						<?php if( $options->get('phone_switcher_v1') ):?>
                        <div class="question"><?php echo wp_kses($options->get('phone_text_v1'), $allowed_html);?> <a href="tel:<?php echo esc_attr(phone_number($options->get('phone_number_v1')));?>"><?php echo wp_kses($options->get('phone_number_v1'), $allowed_html);?></a></div>
                        <?php endif; ?>
						
						<?php if( $options->get('social_profile_switcher_v1') ):
						$icons = $options->get( 'social_profile_v1' );
                        if ( ! empty( $icons ) ) : ?>
						<!--Social Box-->
						<ul class="social-box">
                        	<?php foreach ( $icons as $h_icon ) :
								$header_social_icons = json_decode( urldecode( savelife_set( $h_icon, 'data' ) ) );
								if ( savelife_set( $header_social_icons, 'enable' ) == '' ) {
									continue;
								}
								$icon_class = explode( '-', savelife_set( $header_social_icons, 'icon' ) ); ?>
								<li><a href="<?php echo esc_url(savelife_set( $header_social_icons, 'url' )); ?>" style="background-color:<?php echo esc_attr(savelife_set( $header_social_icons, 'background' )); ?>; color: <?php echo esc_attr(savelife_set( $header_social_icons, 'color' )); ?>"><span class="fab <?php echo esc_attr( savelife_set( $header_social_icons, 'icon' ) ); ?>"></span></a></li>
							<?php endforeach; ?>
						</ul>
                    	<?php endif; endif; ?>
					</div>
				</div>
			</div>
		</div>
    	<?php endif; ?>
        
    	<!--Header-Upper-->
        <div class="header-upper updated">
        	<div class="auto-container">
            	<div class="clearfix">
                	
                	<div class="pull-left logo-box">
                    	<div class="logo"><?php echo savelife_logo( $logo_type, $image_logo, $logo_dimension, $logo_text, $logo_typography ); ?></div>
                    </div>
                    
                    <div class="pull-right">
                    	<div class="nav-outer clearfix">
					
                            <!-- Mobile Navigation Toggler -->
                            <div class="mobile-nav-toggler"><span class="icon flaticon-menu"></span></div>
                            
                            <?php if( $options->get('sidebar_info_v1') ):?>
                            <!-- Main Menu End-->
                            <div class="nav-box">
                                <div class="nav-btn nav-toggler navSidebar-button"><span class="icon flaticon-menu-1"></span></div>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Main Menu -->
                            <nav class="main-menu navbar-expand-md">
                                <div class="navbar-header">
                                    <!-- Toggle Button -->    	
                                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                        <span class="icon-bar"></span>
                                    </button>
                                </div>
                                
                                <div class="navbar-collapse collapse clearfix" id="navbarSupportedContent">
                                    <ul class="navigation clearfix">
                                        <?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
                                            'container_class'=>'navbar-collapse collapse navbar-right',
                                            'menu_class'=>'nav navbar-nav',
                                            'fallback_cb'=>false, 
                                            'items_wrap' => '%3$s', 
                                            'container'=>false,
                                            'depth'=>'3',
                                            'walker'=> new Bootstrap_walker()  
                                        ) ); ?>
                                    </ul>
                                </div>
                            </nav>
                            
                            <!-- Main Menu End-->
                            <div class="outer-box upd clearfix">
                                <?php if( $options->get('search_switcher_v1') ):?>
                                <!--Search Btn-->
                                <a href="#modal-popup-2" class="navsearch-button xs-modal-popup"><i class="icon flaticon-magnifying-glass-1"></i></a>
                                <?php endif; ?>
                                
                                <?php if( $options->get('contact_now_switcher_v1') ):?>
                                <div class="button-box">
                                    <a href="<?php echo esc_url($options->get('contact_now_url_v1'));?>" class="theme-btn btn-style-two"><span class="txt"><?php echo wp_kses($options->get('contact_now_title_v1'), $allowed_html);?></span></a>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--End Header Upper-->
				
		<!-- Mobile Menu  -->
        <div class="mobile-menu">
            <div class="menu-backdrop"></div>
            <div class="close-btn"><span class="icon fa fa-window-close"></span></div>
            
            <nav class="menu-box">
                <div class="nav-logo"><?php echo savelife_logo( $logo_type, $mobile_logo, $mobile_logo_dimension, $logo_text, $logo_typography ); ?></div>
                <div class="menu-outer"><!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header--></div>
            </nav>
        </div>
		<!-- End Mobile Menu -->
    
    </header>
    <!--End Main Header -->
	
    <?php if( $options->get('search_switcher_v1') ):?>
    <!-- xs modal -->
    <div class="zoom-anim-dialog mfp-hide modal-searchPanel" id="modal-popup-2">
        <div class="xs-search-panel">
            <?php get_template_part('searchform1'); ?>
        </div>
    </div><!-- End xs modal -->
    <!-- end language switcher strart -->
    <?php endif; ?>
    
    <?php if( $options->get('sidebar_info_v1') ):?>
    <!-- sidebar cart item -->
	<div class="xs-sidebar-group info-group">
		<div class="xs-overlay xs-bg-black"></div>
		<div class="xs-sidebar-widget">
			<div class="sidebar-widget-container">
				<div class="widget-heading">
					<a href="#" class="close-side-widget">X</a>
				</div>
				<div class="sidebar-textwidget">
					<!-- Sidebar Info Content -->
                    <div class="sidebar-info-contents">
                        <div class="content-inner">
                            <div class="logo">
                                <?php echo savelife_logo( $logo_type, $sidebar_logo, $sidebar_logo_dimension, $logo_text, $logo_typography ); ?>
                            </div>
                            <div class="content-box">
                                <?php if( $options->get('sidebar_title_v1') ):?>
                                <h2><?php echo wp_kses($options->get('sidebar_title_v1'), $allowed_html);?></h2>
                                <?php endif; ?>
                                
                                <?php if( $options->get('sidebar_text_v1') ):?>
                                <p class="text"><?php echo wp_kses($options->get('sidebar_text_v1'), $allowed_html);?></p>
                                <?php endif; ?>
                                
                                <?php if( $options->get('sidebar_button_switcher_v1') ):?>
                                <a href="<?php echo esc_url($options->get('sidebar_button_url_v1'));?>" class="theme-btn btn-style-two"><span class="txt"><?php echo wp_kses($options->get('sidebar_button_title_v1'), $allowed_html);?></span></a>
                                <?php endif; ?>
                            </div>
                            <div class="contact-info">
								<?php if( $options->get('sidebar_contact_info_title_v1') ):?>
                                <h2><?php echo wp_kses($options->get('sidebar_contact_info_title_v1'), $allowed_html);?></h2>
								<?php endif; ?>
                                
                                <ul class="list-style-two">
                                	<?php if( $options->get('sidebar_address_v1') ):?>
                                    <li><span class="icon flaticon-map-1"></span><?php echo wp_kses($options->get('sidebar_address_v1'), $allowed_html);?></li>
                                    <?php endif; ?>
                                    
                                	<?php if( $options->get('sidebar_email_v1') ):?>
                                    <li><span class="icon flaticon-telephone"></span><?php echo wp_kses($options->get('sidebar_email_v1'), $allowed_html);?></li>
                                    <?php endif; ?>
                                    
                                	<?php if( $options->get('sidebar_phone_no_v1') ):?>
                                    <li><span class="icon flaticon-message-1"></span><?php echo wp_kses($options->get('sidebar_phone_no_v1'), $allowed_html);?></li>
                                    <?php endif; ?>
                                    
                                	<?php if( $options->get('sidebar_working_hour_v1') ):?>
                                    <li><span class="icon flaticon-timetable"></span><?php echo wp_kses($options->get('sidebar_working_hour_v1'), $allowed_html);?></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            
                        	<?php if( $options->get('sidebar_social_profile_switcher_v1') ):
							$icons = $options->get( 'sidebar_social_profile_v1' );
                        	if ( ! empty( $icons ) ) : ?>
                            <!-- Social Box -->
                            <ul class="social-box">
                            	<?php foreach ( $icons as $h_icon ) :
									$header_social_icons = json_decode( urldecode( savelife_set( $h_icon, 'data' ) ) );
									if ( savelife_set( $header_social_icons, 'enable' ) == '' ) {
										continue;
									}
									$icon_class = explode( '-', savelife_set( $header_social_icons, 'icon' ) ); ?>
									<li><a href="<?php echo esc_url(savelife_set( $header_social_icons, 'url' )); ?>" style="background-color:<?php echo esc_attr(savelife_set( $header_social_icons, 'background' )); ?>; color: <?php echo esc_attr(savelife_set( $header_social_icons, 'color' )); ?>" class="fab <?php echo esc_attr( savelife_set( $header_social_icons, 'icon' ) ); ?>" target="_blank"></a></li>
								<?php endforeach; ?>
                            </ul>
							<?php endif; endif; ?>
                        </div>
                    </div>
				</div>
			</div>
		</div>
	</div>
	<!-- END sidebar widget item -->
    <?php endif; ?>