<?php get_header(); 
$data = \SAVELIFE\Includes\Classes\Common::instance()->data( 'single-campaign' )->get();
$layout = $data->get( 'layout' );
$sidebar = $data->get( 'sidebar' );
if (is_active_sidebar( $sidebar )) {$layout = 'right';} else{$layout = 'full';}
$class = ( !$layout || $layout == 'full' ) ? 'col-xs-12 col-sm-12 col-md-12' : 'col-lg-8 col-md-12 col-sm-12';
$options = savelife_WSH()->option();
do_action( 'savelife_banner', $data );
$allowed_tags = wp_kses_allowed_html('post'); ?>

<!--Sidebar Page Container-->
<div class="sidebar-page-container">
    <div class="auto-container">
        <div class="row clearfix">
        	<?php
				if ( $data->get( 'layout' ) == 'left' ) {
					do_action( 'savelife_sidebar', $data );
				}
			?>
            <div class="content-side <?php echo esc_attr( $class ); ?>">
            	
				<?php while ( have_posts() ) : the_post();
				$campaign = charitable_get_current_campaign(); ?>
                    <div class="causes-single">
                        <div class="inner-box">
							<div class="image">
                            	<?php the_post_thumbnail('savelife_770x450'); ?>
                            </div>
                        	<div class="upper-box">
                        		<!--Donates-->
                                <div class="donates">
                                    <div class="donate-percentage">
										<div class="donate-bar">
											<div class="bar-inner"><div class="bar progress-line" data-width="<?php echo esc_attr($campaign->get_percent_donated_raw());?>"><div class="count-box"><span class="count-text" data-speed="2500" data-stop="<?php echo esc_attr($campaign->get_percent_donated_raw());?>">0</span>%</div></div></div>
										</div>
										<div class="donate-bar-info">
											<div class="donate-percent"></div>
										</div>
										<?php if ( $campaign->has_goal() ):?>
                                        <div class="amounts clearfix">
                                            <div class="pull-left number"><?php echo wp_kses($campaign->get_donation_summary(), true); ?></div>
                                        </div>
                                        <?php endif;?>
									</div>
                                    <a href="<?php echo esc_url(charitable_get_permalink( 'campaign_donation_page', array( 'campaign' => $campaign ) ));?>" class="theme-btn btn-style-three"><span class="txt"><?php esc_html_e('Donate now', 'savelife'); ?></span></a>
                                </div>
								<h2><?php the_title(); ?></h2>
                            </div>
                            <div class="clearfix">
                            	<div class="pull-left">
                                	<h3><?php esc_html_e('Cause Description', 'savelife'); ?></h3>
                                </div>
                            </div>
                            <?php the_content(); ?>
                        </div>
                    </div>
                    
                    <!--End Single blog Post-->
                    <?php comments_template(); ?>
				<?php endwhile; ?>
                
            </div>
        	<?php
				if ( $data->get( 'layout' ) == 'right' ) {
					do_action( 'savelife_sidebar', $data );
				}
			?>
        </div>
    </div>
</div>
<!--End blog area-->

<?php get_footer(); ?>