<?php
return array(
	'title'      => esc_html__( 'Header Setting', 'savelife' ),
	'id'         => 'headers_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'header_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Header Source Type', 'savelife' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'savelife' ),
				'e' => esc_html__( 'Elementor', 'savelife' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'header_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'savelife' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'header_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'header_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Settings', 'savelife' ),
			'required' => array( 'header_source_type', '=', 'd' ),
		),
		array(
		    'id'       => 'header_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Header Styles', 'savelife' ),
		    'subtitle' => esc_html__( 'Choose Header Styles', 'savelife' ),
		    'options'  => array(

			    'header_v1'  => array(
				    'alt' => esc_html__( 'Header Style 1', 'savelife' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header1.png',
			    ),
			    'header_v2'  => array(
				    'alt' => esc_html__( 'Header Style 2', 'savelife' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header2.png',
			    ),
				'header_v3'  => array(
				    'alt' => esc_html__( 'Header Style 3', 'savelife' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header3.png',
			    ),
			    'header_v4'  => array(
				    'alt' => esc_html__( 'Header Style 4', 'savelife' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header4.png',
			    ),
			    'header_v6'  => array(
				    'alt' => esc_html__( 'Header Style 6', 'savelife' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/header/header6.png',
			    ),
			),
			'required' => array( 'header_source_type', '=', 'd' ),
			'default' => 'header_v1',
	    ),
		
		/***********************************************************************
								Header Version 1 Start
		************************************************************************/
		array(
			'id'       => 'header_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style One Settings', 'savelife' ),
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
		),
		array(
		    'id'       => 'show_topbar_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Header Topbar', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Header Topbar.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'welcome_message_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Welcome Message', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Welcome Message.', 'savelife' ),
		    'required' => array( 'show_topbar_v1', '=', true ),
	    ),
		array(
			'id'    => 'welcome_message_v1',
			'type'  => 'text',
			'title' => esc_html__( 'Welcome Message', 'savelife' ),
			'required' => array( 'welcome_message_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'social_profile_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Profiles', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Social Profiles.', 'savelife' ),
		    'required' => array( 'show_topbar_v1', '=', true ),
	    ),
		array(
			'id'    => 'social_profile_v1',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Profiles', 'savelife' ),
			'required' => array( 'social_profile_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'phone_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone Number', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Phone Number.', 'savelife' ),
		    'required' => array( 'show_topbar_v1', '=', true ),
	    ),
		array(
			'id'    => 'phone_text_v1',
			'type'  => 'text',
			'title' => esc_html__( 'Question', 'savelife' ),
			'required' => array( 'phone_switcher_v1', '=', true ),
		),
		array(
			'id'    => 'phone_number_v1',
			'type'  => 'text',
			'title' => esc_html__( 'Phone Number', 'savelife' ),
			'required' => array( 'phone_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'address_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Address', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Address.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'address_v1',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Address', 'savelife' ),
			'required' => array( 'address_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'email_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Email Address', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Email Address.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'email_v1',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Email Address', 'savelife' ),
		    'required' => array( 'email_switcher_v1', '=', true ),
	    ),
		array(
		    'id'       => 'working_hour_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Working Hours', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Working Hours.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'working_hour_v1',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Working Hours', 'savelife' ),
		    'required' => array( 'working_hour_switcher_v1', '=', true ),
	    ),
		array(
		    'id'       => 'search_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search Icon', 'savelife' ),
		    'subtitle'     => esc_html__( 'Enable/Disable Search Icon.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'contact_now_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Contact Now', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Contact Now.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v1' ),
	    ),
		array(
		    'id'       => 'contact_now_title_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( "Contact Now's Button Title", 'savelife' ),
			'required' => array( 'contact_now_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'contact_now_url_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( "Contact Now's Button URL", 'savelife' ),
			'required' => array( 'contact_now_switcher_v1', '=', true ),
		),
		
		/***********************************************************************
								Sidebar Info Version 1
		************************************************************************/
		array(
            'id' => 'sidebar_info_v1',
            'type' => 'switch',
            'title' => esc_html__('Enable Sidebar Information', 'savelife'),
		    'subtitle'     => esc_html__( 'Enable/Disable Sidebar.', 'savelife' ),
            'default' => true,
			'required' => array( 'header_style_settings', '=', 'header_v1' ),
        ),
		array(
            'id'       => 'sidebar_logo_v1',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Logo', 'savelife' ),
            'subtitle' => esc_html__( 'Upload sidebar logo image', 'savelife' ),
            'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/logo-2.png' ),
            'required' => array( 'sidebar_info_v1', '=', true ),
        ),
		array(
			'id'       => 'sidebar_logo_dimension_v1',
			'type'     => 'dimensions',
			'title'    => esc_html__( 'Sidebar Mobile Logo Dimentions', 'savelife' ),
			'subtitle' => esc_html__( 'Select Mobile Logo Dimentions', 'savelife' ),
			'units'    => array( 'em', 'px', '%' ),
			'default'  => array( 'Width' => '', 'Height' => '' ),
			'required' => array( 'mobile_logo_v1', '=', true ),
		),
		array(
		    'id'       => 'sidebar_title_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Title', 'savelife' ),
			'required' => array( 'sidebar_info_v1', '=', true ),
		),
		array(
		    'id'       => 'sidebar_text_v1',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Description', 'savelife' ),
			'required' => array( 'sidebar_info_v1', '=', true ),
		),
		array(
		    'id'       => 'sidebar_button_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Button', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Button.', 'savelife' ),
			'required' => array( 'sidebar_info_v1', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_button_title_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button Title", 'savelife' ),
			'required' => array( 'sidebar_button_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'sidebar_button_url_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button URL", 'savelife' ),
			'required' => array( 'sidebar_button_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'sidebar_contact_info_title_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Contact Info Title', 'savelife' ),
			'required' => array( 'sidebar_info_v1', '=', true ),
		),
		array(
		    'id'       => 'sidebar_address_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Address', 'savelife' ),
			'required' => array( 'sidebar_info_v1', '=', true ),
		),
		array(
		    'id'       => 'sidebar_email_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Address', 'savelife' ),
		    'required' => array( 'sidebar_info_v1', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_phone_no_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'savelife' ),
		    'required' => array( 'sidebar_info_v1', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_working_hour_v1',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Working Hours', 'savelife' ),
		    'required' => array( 'sidebar_info_v1', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_social_profile_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Profiles', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Social Profiles.', 'savelife' ),
		    'required' => array( 'sidebar_info_v1', '=', true ),
	    ),
		array(
			'id'    => 'sidebar_social_profile_v1',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Profiles', 'savelife' ),
			'required' => array( 'sidebar_social_profile_switcher_v1', '=', true ),
		),
		
		/***********************************************************************
								Header Version 2 Start
		************************************************************************/
		array(
			'id'       => 'header_v2_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Two Settings', 'savelife' ),
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
		),
		array(
		    'id'       => 'show_topbar_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable header Topbar', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		array(
		    'id'       => 'language_switcher_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Language', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Language.', 'savelife' ),
		    'required' => array( 'show_topbar_v2', '=', true ),
	    ),
		array(
		    'id'       => 'phone_switcher_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone Number', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Phone Number.', 'savelife' ),
		    'required' => array( 'show_topbar_v2', '=', true ),
	    ),
		array(
			'id'    => 'phone_message_v2',
			'type'  => 'text',
			'title' => esc_html__( 'Phone Message', 'savelife' ),
			'required' => array( 'phone_switcher_v2', '=', true ),
		),
		array(
			'id'    => 'phone_number_v2',
			'type'  => 'text',
			'title' => esc_html__( 'Phone Number', 'savelife' ),
			'required' => array( 'phone_switcher_v2', '=', true ),
		),
		array(
		    'id'       => 'contact_us_switcher_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Contact Us Link', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Contact Us Link.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		array(
		    'id'       => 'contact_us_title_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button Title", 'savelife' ),
			'required' => array( 'contact_us_switcher_v2', '=', true ),
		),
		array(
		    'id'       => 'contact_us_url_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button URL", 'savelife' ),
			'required' => array( 'contact_us_switcher_v2', '=', true ),
		),
		array(
		    'id'       => 'donate_now_switcher_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Donate Now Link', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Donate Now Link.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		array(
		    'id'       => 'donate_now_title_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button Title", 'savelife' ),
			'required' => array( 'donate_now_switcher_v2', '=', true ),
		),
		array(
		    'id'       => 'donate_now_url_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button URL", 'savelife' ),
			'required' => array( 'donate_now_switcher_v2', '=', true ),
		),
		array(
		    'id'       => 'login_register_switcher_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Login Register', 'savelife' ),
		    'subtitle'     => esc_html__( 'Enable/Disable Login Register.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		array(
		    'id'       => 'search_switcher_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search Icon', 'savelife' ),
		    'subtitle'     => esc_html__( 'Enable/Disable Search Icon.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v2' ),
	    ),
		
		/***********************************************************************
								Sidebar Info Version 2
		************************************************************************/
		array(
            'id' => 'sidebar_info_v2',
            'type' => 'switch',
            'title' => esc_html__('Enable Sidebar Information', 'savelife'),
		    'subtitle'     => esc_html__( 'Enable/Disable Sidebar.', 'savelife' ),
            'default' => true,
			'required' => array( 'header_style_settings', '=', 'header_v2' ),
        ),
		array(
            'id'       => 'sidebar_logo_v2',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Logo', 'savelife' ),
            'subtitle' => esc_html__( 'Upload sidebar logo image', 'savelife' ),
            'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/logo-2.png' ),
            'required' => array( 'sidebar_info_v2', '=', true ),
        ),
		array(
		    'id'       => 'sidebar_title_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Title', 'savelife' ),
			'required' => array( 'sidebar_info_v2', '=', true ),
		),
		array(
		    'id'       => 'sidebar_text_v2',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Description', 'savelife' ),
			'required' => array( 'sidebar_info_v2', '=', true ),
		),
		array(
		    'id'       => 'sidebar_button_switcher_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Button', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Button.', 'savelife' ),
			'required' => array( 'sidebar_info_v2', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_button_title_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button Title", 'savelife' ),
			'required' => array( 'sidebar_button_switcher_v2', '=', true ),
		),
		array(
		    'id'       => 'sidebar_button_url_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button URL", 'savelife' ),
			'required' => array( 'sidebar_button_switcher_v2', '=', true ),
		),
		array(
		    'id'       => 'sidebar_contact_info_title_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Contact Info Title', 'savelife' ),
			'required' => array( 'sidebar_info_v2', '=', true ),
		),
		array(
		    'id'       => 'sidebar_address_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Address', 'savelife' ),
			'required' => array( 'sidebar_info_v2', '=', true ),
		),
		array(
		    'id'       => 'sidebar_email_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Address', 'savelife' ),
		    'required' => array( 'sidebar_info_v2', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_phone_no_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'savelife' ),
		    'required' => array( 'sidebar_info_v2', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_working_hour_v2',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Working Hours', 'savelife' ),
		    'required' => array( 'sidebar_info_v2', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_social_profile_switcher_v2',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Profiles', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Social Profiles.', 'savelife' ),
		    'required' => array( 'sidebar_info_v2', '=', true ),
	    ),
		array(
			'id'    => 'sidebar_social_profile_v2',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Profiles', 'savelife' ),
			'required' => array( 'sidebar_social_profile_switcher_v2', '=', true ),
		),
		
		/***********************************************************************
								Header Version 3 Start
		************************************************************************/
		array(
			'id'       => 'header_v3_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Three Settings', 'savelife' ),
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
		),
		
		/***********************************************************************
								Sidebar Info Version 3
		************************************************************************/
		array(
            'id' => 'sidebar_info_v3',
            'type' => 'switch',
            'title' => esc_html__('Enable Sidebar Information', 'savelife'),
		    'subtitle'     => esc_html__( 'Enable/Disable Sidebar.', 'savelife' ),
            'default' => true,
			'required' => array( 'header_style_settings', '=', 'header_v3' ),
        ),
		array(
            'id'       => 'sidebar_logo_v3',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Logo', 'savelife' ),
            'subtitle' => esc_html__( 'Upload sidebar logo image', 'savelife' ),
            'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/logo-2.png' ),
            'required' => array( 'sidebar_info_v3', '=', true ),
        ),
		array(
		    'id'       => 'sidebar_title_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Title', 'savelife' ),
			'required' => array( 'sidebar_info_v3', '=', true ),
		),
		array(
		    'id'       => 'sidebar_text_v3',
		    'type'     => 'textarea',
		    'title'    => esc_html__( 'Description', 'savelife' ),
			'required' => array( 'sidebar_info_v3', '=', true ),
		),
		array(
		    'id'       => 'sidebar_button_switcher_v3',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Button', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Button.', 'savelife' ),
			'required' => array( 'sidebar_info_v3', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_button_title_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button Title", 'savelife' ),
			'required' => array( 'sidebar_button_switcher_v3', '=', true ),
		),
		array(
		    'id'       => 'sidebar_button_url_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( "Button URL", 'savelife' ),
			'required' => array( 'sidebar_button_switcher_v3', '=', true ),
		),
		array(
		    'id'       => 'sidebar_contact_info_title_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Contact Info Title', 'savelife' ),
			'required' => array( 'sidebar_info_v3', '=', true ),
		),
		array(
		    'id'       => 'sidebar_address_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Address', 'savelife' ),
			'required' => array( 'sidebar_info_v3', '=', true ),
		),
		array(
		    'id'       => 'sidebar_email_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Email Address', 'savelife' ),
		    'required' => array( 'sidebar_info_v3', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_phone_no_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Phone Number', 'savelife' ),
		    'required' => array( 'sidebar_info_v3', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_working_hour_v3',
		    'type'     => 'text',
		    'title'    => esc_html__( 'Working Hours', 'savelife' ),
		    'required' => array( 'sidebar_info_v3', '=', true ),
	    ),
		array(
		    'id'       => 'sidebar_social_profile_switcher_v3',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Profiles', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Social Profiles.', 'savelife' ),
		    'required' => array( 'sidebar_info_v3', '=', true ),
	    ),
		array(
			'id'    => 'sidebar_social_profile_v3',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Profiles', 'savelife' ),
			'required' => array( 'sidebar_social_profile_switcher_v3', '=', true ),
		),
		
		/***********************************************************************
								Header Version 4 Start
		************************************************************************/
		array(
			'id'       => 'header_v4_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Four Settings', 'savelife' ),
			'required' => array( 'header_style_settings', '=', 'header_v4' ),
		),
		
		/***********************************************************************
								Sidebar Info Version 4
		************************************************************************/
		array(
            'id' => 'sidebar_info_v4',
            'type' => 'switch',
            'title' => esc_html__('Enable Sidebar Information', 'savelife'),
		    'subtitle'     => esc_html__( 'Enable/Disable Sidebar.', 'savelife' ),
            'default' => true,
			'required' => array( 'header_style_settings', '=', 'header_v4' ),
        ),
		array(
            'id'       => 'sidebar_logo_v4',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Sidebar Logo', 'savelife' ),
            'subtitle' => esc_html__( 'Upload sidebar logo image', 'savelife' ),
            'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/logo.png' ),
            'required' => array( 'sidebar_info_v4', '=', true ),
        ),
		
		/***********************************************************************
								Header Version 6 Start
		************************************************************************/
		array(
			'id'       => 'header_v6_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Header Style Six Settings', 'savelife' ),
			'required' => array( 'header_style_settings', '=', 'header_v6' ),
		),
		array(
		    'id'       => 'email_switcher_v6',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Email', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Email.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v6' ),
	    ),
		array(
			'id'    => 'email_v6',
			'type'  => 'text',
			'title' => esc_html__( 'Email V6', 'savelife' ),
			'required' => array( 'email_switcher_v6', '=', true ),
		),
		array(
		    'id'       => 'address_switcher_v6',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Address', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Address.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v6' ),
	    ),
		array(
			'id'    => 'address_v6',
			'type'  => 'textarea',
			'title' => esc_html__( 'Address', 'savelife' ),
			'required' => array( 'address_switcher_v6', '=', true ),
		),
		array(
		    'id'       => 'phone_switcher_v6',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Phone.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v6' ),
	    ),
		array(
			'id'    => 'phone_v6',
			'type'  => 'textarea',
			'title' => esc_html__( 'Phone', 'savelife' ),
			'required' => array( 'phone_switcher_v6', '=', true ),
		),
		array(
		    'id'       => 'search_v6',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Search Icon', 'savelife' ),
		    'subtitle'     => esc_html__( 'Enable/Disable Search Icon.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v6' ),
	    ),
		
		array(
		    'id'       => 'social_profile_switcher_v6',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Social Profiles', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Social Profiles.', 'savelife' ),
		    'required' => array( 'header_style_settings', '=', 'header_v6' ),
	    ),
		array(
			'id'    => 'social_profile_v6',
			'type'  => 'social_media',
			'title' => esc_html__( 'Social Profiles', 'savelife' ),
			'required' => array( 'social_profile_switcher_v6', '=', true ),
		),
		
		array(
			'id'       => 'header_style_section_end',
			'type'     => 'section',
			'indent'      => false,
			'required' => [ 'header_source_type', '=', 'd' ],
		),
	),
);
