<?php

return array(
	'title'      => esc_html__( 'Footer Setting', 'savelife' ),
	'id'         => 'footer_setting',
	'desc'       => '',
	'subsection' => false,
	'fields'     => array(
		array(
			'id'      => 'footer_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Footer Source Type', 'savelife' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'savelife' ),
				'e' => esc_html__( 'Elementor', 'savelife' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => 'footer_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'savelife' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'	=> -1
			],
			'required' => [ 'footer_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'footer_style_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Settings', 'savelife' ),
			'required' => array( 'footer_source_type', '=', 'd' ),
		),
		array(
		    'id'       => 'footer_style_settings',
		    'type'     => 'image_select',
		    'title'    => esc_html__( 'Choose Footer Styles', 'savelife' ),
		    'subtitle' => esc_html__( 'Choose Footer Styles', 'savelife' ),
		    'options'  => array(

			    'footer_v1'  => array(
				    'alt' => esc_html__( 'Footer Style 1', 'savelife' ),
				    'img' => get_template_directory_uri() . '/assets/images/redux/footer/footer1.png',
			    )
			),
			'required' => array( 'footer_source_type', '=', 'd' ),
			'default' => 'footer_v6',
	    ),
		
		/***********************************************************************
								Footer Version 1 Start
		************************************************************************/
		array(
			'id'       => 'footer_v1_settings_section_start',
			'type'     => 'section',
			'indent'      => true,
			'title'    => esc_html__( 'Footer Style One Settings', 'savelife' ),
			'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
		),
		array(
		    'id'       => 'footer_top_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Footer Top', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Footer Top.', 'savelife' ),
		    'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
	    ),
		array(
		    'id'       => 'footer_email_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Email Address', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Email Address.', 'savelife' ),
		    'required' => array( 'footer_top_switcher_v1', '=', true ),
	    ),
		array(
			'id'      => 'footer_email_v1',
			'type'    => 'text',
			'title'   => __( 'Email Address', 'savelife' ),
			'required' => array( 'footer_email_switcher_v1', '=', true ),
		),
		array(
			'id'      => 'footer_email_text_v1',
			'type'    => 'text',
			'title'   => __( 'Email Text', 'savelife' ),
			'required' => array( 'footer_email_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'footer_phone_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Phone Number', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Phone Address.', 'savelife' ),
		    'required' => array( 'footer_top_switcher_v1', '=', true ),
	    ),
		array(
			'id'      => 'footer_phone_v1',
			'type'    => 'text',
			'title'   => __( 'Phone Number', 'savelife' ),
			'required' => array( 'footer_phone_switcher_v1', '=', true ),
		),
		array(
			'id'      => 'footer_phone_text_v1',
			'type'    => 'text',
			'title'   => __( 'Phone Text', 'savelife' ),
			'required' => array( 'footer_phone_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'footer_address_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Address', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Address.', 'savelife' ),
		    'required' => array( 'footer_top_switcher_v1', '=', true ),
	    ),
		array(
			'id'      => 'footer_address_v1',
			'type'    => 'textarea',
			'title'   => __( 'Address', 'savelife' ),
			'required' => array( 'footer_address_switcher_v1', '=', true ),
		),
		array(
			'id'      => 'footer_address_text_v1',
			'type'    => 'textarea',
			'title'   => __( 'Address Text', 'savelife' ),
			'required' => array( 'footer_address_switcher_v1', '=', true ),
		),
		
		
		
		array(
		    'id'       => 'footer_bottom_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Footer Bottom', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Footer Bottom.', 'savelife' ),
		    'required' => array( 'footer_style_settings', '=', 'footer_v1' ),
	    ),
		array(
		    'id'       => 'copyrights_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Copyrights Text', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Copyrights Text.', 'savelife' ),
		    'required' => array( 'footer_bottom_switcher_v1', '=', true ),
	    ),
		array(
			'id'      => 'copyrights',
			'type'    => 'textarea',
			'title'   => __( 'Copyrights', 'savelife' ),
			'required' => array( 'copyrights_switcher_v1', '=', true ),
		),
		array(
		    'id'       => 'footer_menu_switcher_v1',
		    'type'     => 'switch',
		    'title'    => esc_html__( 'Enable Footer Menu', 'savelife' ),
		    'subtitle' => esc_html__( 'Enable/Disable Footer Menu.', 'savelife' ),
		    'required' => array( 'footer_bottom_v1', '=', true ),
	    ),
		
		array(
			'id'       => 'footer_default_ed',
			'type'     => 'section',
			'indent'   => false,
			'required' => [ 'footer_source_type', '=', 'd' ],
		),
	),
);
