<?php

return array(
	'title'      => esc_html__( '404 Page Settings', 'savelife' ),
	'id'         => '404_setting',
	'desc'       => '',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => '404_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( '404 Source Type', 'savelife' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'savelife' ),
				'e' => esc_html__( 'Elementor', 'savelife' ),
			),
			'default' => 'd',
		),
		array(
			'id'       => '404_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'savelife' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
			],
			'required' => [ '404_source_type', '=', 'e' ],
		),
		array(
			'id'       => '404_default_st',
			'type'     => 'section',
			'title'    => esc_html__( '404 Default', 'savelife' ),
			'indent'   => true,
			'required' => [ '404_source_type', '=', 'd' ],
		),
		array(
			'id'      => '404_page_banner',
			'type'    => 'switch',
			'title'   => esc_html__( 'Show Banner', 'savelife' ),
			'desc'    => esc_html__( 'Enable to show banner on blog', 'savelife' ),
			'default' => true,
		),
		array(
			'id'       => '404_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Banner Section Title', 'savelife' ),
			'desc'     => esc_html__( 'Enter the title to show in banner section', 'savelife' ),
			'required' => array( '404_page_banner', '=', true ),
		),
		array(
			'id'       => '404_page_background',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'savelife' ),
			'desc'     => esc_html__( 'Insert background image for banner', 'savelife' ),
			'default'  => '',
			'required' => array( '404_page_banner', '=', true ),
		),
		
		//404 Section
		array(
			'id'       => 'error_page_image',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Error Page Background Image', 'savelife' ),
			'desc'     => esc_html__( 'Upload Error Page background image for section', 'savelife' ),
		),
		array(
			'id'    => '404-title',
			'type'  => 'text',
			'title' => esc_html__( '404 page not found Title', 'savelife' ),
			'desc'  => esc_html__( 'Enter 404 section title that you want to show', 'savelife' ),
		),
		array(
			'id'    => '404-page-title',
			'type'  => 'textarea',
			'title' => esc_html__( '404 Page Title', 'savelife' ),
			'desc'  => esc_html__( 'Enter 404 page title that you want to show.', 'savelife' ),
		),
		array(
			'id'    => '404-page-text',
			'type'  => 'textarea',
			'title' => esc_html__( '404 Page Description', 'savelife' ),
			'desc'  => esc_html__( 'Enter 404 page description that you want to show.', 'savelife' ),
		),
		array(
			'id'       => 'back_home_btn_label',
			'type'     => 'text',
			'title'    => esc_html__( 'Button Label', 'savelife' ),
			'desc'     => esc_html__( 'Enter back to home button label that you want to show.', 'savelife' ),
			'default'  => esc_html__( 'Go To Home', 'savelife' ),
			'required' => array( 'back_home_btn', '=', true ),
		),
		array(
			'id'     => '404_post_settings_end',
			'type'   => 'section',
			'indent' => false,
		),
	),
);