<?php
/**
 * 404 page file
 *
 * @package    WordPress
 * @subpackage Oswo
 * @author     Theme Expo <admin@themeexpo.com>
 * @version    1.0
 */

$allowed_html = wp_kses_allowed_html( 'post' );
$error_page_img    = $options->get( 'error_page_image' );
$error_page_img    = savelife_set( $error_page_img, 'url', SAVELIFE_URI . 'assets/images/background/1.jpg' );
?>
<?php get_header();
$data = \SAVELIFE\Includes\Classes\Common::instance()->data( '404' )->get();
$options = savelife_WSH()->option();
if ( class_exists( '\Elementor\Plugin' ) AND $data->get( 'tpl-type' ) == 'e' AND $data->get( 'tpl-elementor' ) ) {
	echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $data->get( 'tpl-elementor' ) );
} else {
?>

	<?php if ( class_exists( '\Elementor\Plugin' )):?>
	<?php do_action( 'savelife_banner', $data );?>
	<?php else:?>
    <!--Page Title-->
    <section class="page-title" style="background-image:url(<?php echo esc_url( $data->get( 'banner' ) ); ?>);">
        <div class="auto-container">
            <div class="content-box clearfix">
                <!--Title -->
                <div class="title-column">
                    <h1><?php if( $data->get( 'title' ) ) echo wp_kses( $data->get( 'title' ), true ); else( wp_title( '' ) ); ?></h1>
                </div>
                <!--Bread Crumb -->
                <div class="breadcrumb-column">
                    <ul class="bread-crumb clearfix">
                        <?php echo savelife_the_breadcrumb(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <!--End Page Title-->
    <?php endif;?>
	
    <!-- Error Section -->
    <section class="error-section" style="background-image:url(<?php echo esc_url($error_page_img); ?>)">
    	<div class="auto-container">
        	<div class="content">
            	<h1>
                	<?php 
						if( $options->get( '404-page_title' ) ){
							echo wp_kses( $options->get( '404-page_title' ), true );
						}else{
							esc_html_e( '404', 'savelife' );
						}
					?>
                </h1>
                <h2>
                	<?php 
						if( $options->get( '404-page_subtitle' ) ){
							echo wp_kses( $options->get( '404-page_subtitle' ), true );
						}else{
							esc_html_e( 'Oops! That page can’t be found', 'savelife' );
						}
					?>
                </h2>
                <div class="text">
                	<?php 
						if( $options->get( '404-page-text' ) ){
							echo wp_kses( $options->get( '404-page-text' ), true );
						}else{
							esc_html_e( 'Sorry, but the page you are looking for does not existing', 'savelife' );
						}
					?>
                </div>
                <?php if ( $options->get( 'back_home_btn', true ) ) : ?>
                <a href="<?php echo( home_url( '/' ) ); ?>" class="theme-btn btn-style-three"><span class="txt">
                	<?php 
						if( $options->get( 'back_home_btn_label' ) ){
							echo wp_kses( $options->get( 'back_home_btn_label' ), true );
						}else{
							esc_html_e( 'Go to home page', 'savelife' );
						}
					?>
                </span></a>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- End Error Section -->
     
<?php
}
get_footer(); ?>
