<?php namespace SAVELIFEPLUGIN\Inc;

use SAVELIFEPLUGIN\Inc\Abstracts\Taxonomy;

class Taxonomies extends Taxonomy {

	public static function init() {

		$labels = array(
			'name'              => _x( 'Project Category', 'wpsavelife' ),
			'singular_name'     => _x( 'Project Category', 'wpsavelife' ),
			'search_items'      => __( 'Search Category', 'wpsavelife' ),
			'all_items'         => __( 'All Categories', 'wpsavelife' ),
			'parent_item'       => __( 'Parent Category', 'wpsavelife' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpsavelife' ),
			'edit_item'         => __( 'Edit Category', 'wpsavelife' ),
			'update_item'       => __( 'Update Category', 'wpsavelife' ),
			'add_new_item'      => __( 'Add New Category', 'wpsavelife' ),
			'new_item_name'     => __( 'New Category Name', 'wpsavelife' ),
			'menu_name'         => __( 'Project Category', 'wpsavelife' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'project_cat' ),
		);
		register_taxonomy( 'project_cat', 'savelife_project', $args );
		
		//Testimonials Taxonomy Start
		$labels = array(
			'name'              => _x( 'Testimonials Category', 'wpsavelife' ),
			'singular_name'     => _x( 'Testimonials Category', 'wpsavelife' ),
			'search_items'      => __( 'Search Category', 'wpsavelife' ),
			'all_items'         => __( 'All Categories', 'wpsavelife' ),
			'parent_item'       => __( 'Parent Category', 'wpsavelife' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpsavelife' ),
			'edit_item'         => __( 'Edit Category', 'wpsavelife' ),
			'update_item'       => __( 'Update Category', 'wpsavelife' ),
			'add_new_item'      => __( 'Add New Category', 'wpsavelife' ),
			'new_item_name'     => __( 'New Category Name', 'wpsavelife' ),
			'menu_name'         => __( 'Testimonials Category', 'wpsavelife' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'testimonials_cat' ),
		);
		register_taxonomy( 'testimonials_cat', 'save_testimonials', $args );
		
		
		//Team Taxonomy Start
		$labels = array(
			'name'              => _x( 'Team Category', 'wpsavelife' ),
			'singular_name'     => _x( 'Team Category', 'wpsavelife' ),
			'search_items'      => __( 'Search Category', 'wpsavelife' ),
			'all_items'         => __( 'All Categories', 'wpsavelife' ),
			'parent_item'       => __( 'Parent Category', 'wpsavelife' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpsavelife' ),
			'edit_item'         => __( 'Edit Category', 'wpsavelife' ),
			'update_item'       => __( 'Update Category', 'wpsavelife' ),
			'add_new_item'      => __( 'Add New Category', 'wpsavelife' ),
			'new_item_name'     => __( 'New Category Name', 'wpsavelife' ),
			'menu_name'         => __( 'Team Category', 'wpsavelife' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'team_cat' ),
		);
		register_taxonomy( 'team_cat', 'savelife_team', $args );
		
		//Faqs Taxonomy Start
		$labels = array(
			'name'              => _x( 'Faqs Category', 'wpsavelife' ),
			'singular_name'     => _x( 'Faq Category', 'wpsavelife' ),
			'search_items'      => __( 'Search Category', 'wpsavelife' ),
			'all_items'         => __( 'All Categories', 'wpsavelife' ),
			'parent_item'       => __( 'Parent Category', 'wpsavelife' ),
			'parent_item_colon' => __( 'Parent Category:', 'wpsavelife' ),
			'edit_item'         => __( 'Edit Category', 'wpsavelife' ),
			'update_item'       => __( 'Update Category', 'wpsavelife' ),
			'add_new_item'      => __( 'Add New Category', 'wpsavelife' ),
			'new_item_name'     => __( 'New Category Name', 'wpsavelife' ),
			'menu_name'         => __( 'Faq Category', 'wpsavelife' ),
		);
		$args   = array(
			'hierarchical'       => true,
			'labels'             => $labels,
			'show_ui'            => true,
			'show_admin_column'  => true,
			'query_var'          => true,
			'public'             => true,
			'publicly_queryable' => true,
			'rewrite'            => array( 'slug' => 'faqs_cat' ),
		);
		register_taxonomy( 'faqs_cat', 'savelife_faqs', $args );
	}
	
}
