<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Welcome_Our_Donation extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_welcome_our_donation';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Welcome To Our Donation', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'welcome_our_donation',
            [
                'label' => esc_html__( 'Welcome To Our Donation', 'savelife' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'features',
            [
                'label'       => __( 'Donation Features', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'video_image',
            [
                'label' => __( 'Background Video Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'video_url',
            [
                'label'       => __( 'Video URL', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'placeholder' => __( 'https://your-link.com', 'savelife' ),
            ]
        );
		$this->add_control(
            'fact_counter',
            [
                'label'   => esc_html__( 'FunFacts', 'savelife' ),
                'type' => Controls_Manager::REPEATER,
                'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'savelife'),
                            'type' => Controls_Manager::TEXT,
                        ],
                        [
                            'name' => 'icon',
                            'label' => esc_html__('Select Icon', 'savelife'),
                            'type' => Controls_Manager::SELECT2,
                            'options' => get_fontawesome_icons(),
                        ],
                        [
                            'name' => 'counter_start',
                            'label' => esc_html__('Counter Start', 'savelife'),
                            'type' => Controls_Manager::NUMBER,
                            'default' => 0,
                        ],
                        [
                            'name' => 'counter_stop',
                            'label' => esc_html__('Counter Stop', 'savelife'),
                            'type' => Controls_Manager::TEXT,
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
        ?>
        
        <!--Welcome Section-->
        <section class="updated-welcome-section">
            <div class="auto-container">
                <div class="row clearfix">
                
                    <!--Content Column / Fact Counter Two-->
                    <div class="content-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-box">
                            <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                            <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                            
                            <?php $features_text = $settings['features'];
                            if(!empty($features_text)){
                            $features = explode("\n", ($features_text));?>
                            <div class="row clearfix">
                                <!-- Column -->
                                <div class="column col-lg-12 col-md-12 col-sm-12">
                                    <ul class="list-style-one our-donation-list">
                                        <?php foreach($features as $feature):?>
                                        <li><?php echo wp_kses($feature, true); ?></li>
                                    	<?php endforeach;?>
                                    </ul>
                                </div>
                            </div>
                            <?php } ?>
                            
                            <!--Fact Counter Two-->
                            <div class="fact-counter">
                                <div class="clearfix">
                            		<?php foreach($settings['fact_counter'] as $key => $item): ?>
                                    <!--Column-->
                                    <div class="inner-column light-bg counter-column wow fadeIn">
                                        <div class="inner">
                                            <div class="icon-box"><span class="icon <?php echo esc_attr($item['icon']); ?>"></span></div>
                                            <div class="count-outer count-box">
                                                <span class="count-text" data-speed="4000" data-stop="<?php echo esc_attr($item['counter_stop']); ?>"><?php echo esc_attr($item['counter_start']); ?></span>
                                            </div>
                                            <h4 class="counter-title"><?php echo wp_kses($item['title'], true); ?></h4>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--Video Column-->
                    <div class="column col-lg-6 col-md-12 col-sm-12">
                        <div class="video-box">
                            <figure class="image">
                                <img src="<?php echo wp_get_attachment_url($settings['video_image']['id']); ?>" alt="<?php esc_html_e('Awesome Image', 'savelife'); ?>">
                            </figure>
                            <a href="<?php echo wp_kses( $settings['video_url'], true ); ?>" class="lightbox-image overlay-box">
                                <span class="flaticon-play-arrow"><i class="ripple"></i></span>
                            </a>
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        <!--End Welcome Section-->
        
        <?php
    }
}
