<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Latest_News_V2 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_our_latest_news_v2';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Latest News V2', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'our_latest_news_v2',
            [
                'label' => esc_html__( 'Our Latest News V2', 'savelife' ),
            ]
        );
		$this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 150,
                'min'     => 1,
                'max'     => 1000,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 3,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'savelife' ),
                    'title'      => esc_html__( 'Title', 'savelife' ),
                    'menu_order' => esc_html__( 'Menu Order', 'savelife' ),
                    'rand'       => esc_html__( 'Random', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'savelife' ),
                    'ASC'  => esc_html__( 'ASC', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'savelife'),
                'options' => get_categories_list(),
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = savelife_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-savelife' );
        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => savelife_set( $settings, 'query_number' ),
            'orderby'        => savelife_set( $settings, 'query_orderby' ),
            'order'          => savelife_set( $settings, 'query_order' ),
            'paged'         => $paged
        );

        if ( savelife_set( $settings, 'query_exclude' ) ) {
            $settings['query_exclude'] = explode( ',', $settings['query_exclude'] );
            $args['post__not_in']      = savelife_set( $settings, 'query_exclude' );
        }

        if( savelife_set( $settings, 'query_category' ) ) $args['category_name'] = savelife_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );
        $i=1;
        if ( $query->have_posts() ) { ?>
        
        <!-- News Section -->
        <section class="news-section-two" style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="sec-title light">
                    <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                </div>
                <div class="news-carousel owl-carousel owl-theme">
                    <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                    <!-- News Block Three -->
                    <div class="news-block-three">
                        <div class="inner-box">
                            <div class="image-box">
                                <a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_post_thumbnail('savelife_350x230'); ?></a>
                                <!--overlay box-->
                                <ul class="post-meta clearfix">
                                	<li><div class="inner"><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><span class="icon flaticon-comment"></span><br><?php comments_number( '0 Comments', '1 Comment', '% Comments' ); ?></a></div></li>
                                    <li><div class="inner"><a href="<?php echo esc_url(get_month_link(get_the_date('Y'), get_the_date('m'))); ?>"><span class="icon flaticon-calendar-1"></span><br><?php echo wp_kses(get_the_date( 'M d, Y' ), true); ?></div></li>
                                </ul>
                            </div>
                            <div class="lower-content">
                                <ul class="posted">
                                    <li><span class="icon flaticon-calendar"></span> <?php echo wp_kses(get_the_date(), true); ?></li>
                                    <li><span class="icon flaticon-avatar"></span> <?php esc_html_e('By', 'savelife'); ?> <?php the_author(); ?></li>
                                </ul>
                                <h3><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h3>
                                <div class="text"><?php echo wp_kses(wp_trim_words( get_the_content(), $settings['text_limit'] ), true); ?></div>
                                <a class="read-more" href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php esc_html_e('Read More', 'savelife'); ?></a>
                            </div>
                        </div>
                    </div>
                    <!--End News Block-->
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
        <!-- End News Section -->
        
        <?php }

        wp_reset_postdata();
    }
}
