<?php

namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Faqs extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'savelife_our_faqs';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Faqs', 'savelife' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'savelife' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'our_faqs',
			[
				'label' => esc_html__( 'Our Faqs', 'savelife' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'savelife' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'savelife' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'savelife' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Text', 'savelife' ),
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'savelife' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'savelife' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'savelife' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'savelife' ),
					'title'      => esc_html__( 'Title', 'savelife' ),
					'menu_order' => esc_html__( 'Menu Order', 'savelife' ),
					'rand'       => esc_html__( 'Random', 'savelife' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'savelife' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESc' => esc_html__( 'DESC', 'savelife' ),
					'ASC'  => esc_html__( 'ASC', 'savelife' ),
				),
			]
		);
		$this->add_control(
			'query_exclude',
			[
				'label'       => esc_html__( 'Exclude', 'savelife' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Exclude posts, pages, etc. by ID with comma separated.', 'savelife' ),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'savelife'),
                  'options' => get_categories_list('faqs_cat')
				]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = savelife_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-savelife' );
		$args = array(
			'post_type'      => 'savelife_faqs',
			'posts_per_page' => savelife_set( $settings, 'query_number' ),
			'orderby'        => savelife_set( $settings, 'query_orderby' ),
			'order'          => savelife_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		if ( savelife_set( $settings, 'query_exclude' ) ) {
			$settings['query_exclude'] = explode( ',', $settings['query_exclude'] );
			$args['post__not_in']      = savelife_set( $settings, 'query_exclude' );
		}
		
		if( savelife_set( $settings, 'query_category' ) ) $args['faqs_cat'] = savelife_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts()) { 
		
		$count = 1;
		$left_arr = array();
   		$right_arr = array();
					
		?>
		<?php while ( $query->have_posts() ) : $query->the_post();
				
				if($count > 2) $count = 1;
				$active_block = ( $query->current_post == 0 ) ? 'active-block' : '';
				$active = ( $query->current_post == 0 ) ? 'active' : '';
				$current = ( $query->current_post == 0 ) ? 'current' : '';
			?>
			<?php if( ($count == 1)):
				$left_arr[get_the_id()] = ' <li class="accordion block '.$active_block.'">
												<div class="acc-btn '.$active.'"><div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span> <span class="icon icon-minus fa fa-minus"></span></div> '.get_the_title(get_the_id()).'</div>
												<div class="acc-content '.$current.'">
													<div class="content">
														<div class="text">'.wp_trim_words(get_the_content(), $settings['text_limit']).'</div>
													</div>
												</div>
											</li>';
			?>
			<?php else:
				$right_arr[get_the_id()] = ' <li class="accordion block">
												<div class="acc-btn"><div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span> <span class="icon icon-minus fa fa-minus"></span></div> '.get_the_title(get_the_id()).'</div>
												<div class="acc-content">
													<div class="content">
														<div class="text">'.wp_trim_words(get_the_content(), $settings['text_limit']).'</div>
													</div>
												</div>
											</li>';
			?>
			<?php endif; ?>
			<?php $count++; endwhile; ?>	
            
            <!-- Faq's Page Section -->
            <section class="faq-page-section updated">
                <div class="auto-container">
                    
                    <!-- Sec Title -->
                    <div class="sec-title centered">
                        <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                        <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                    </div>
                    
                    <div class="row clearfix">
                        
                        <!-- Column -->
                        <div class="accordian-column col-lg-6 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <ul class="accordion-box">
                                    <?php foreach($left_arr as $key => $content):?>
                                        <?php echo wp_kses_post($content);?>
                                    <?php endforeach;?>
                                </ul>
                            </div>
                        </div>
                        
                        <!-- Column -->
                        <div class="accordian-column col-lg-6 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <ul class="accordion-box">
                                    <?php foreach($right_arr as $key => $right_content):?>
                                        <?php echo wp_kses_post($right_content);?>
                                    <?php endforeach;?>
                                </ul>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </section>
            <!-- End Faq's Page Section -->
            
        <?php }
		wp_reset_postdata();
	}

}
