<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Blog_V1 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_our_blog_v1';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Our Blog V1', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'our_blog_v1',
            [
                'label' => esc_html__( 'Our Blog V1', 'savelife' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => __( 'Enter your title', 'savelife' ),
            ]
        );
		$this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => __( 'Enter your text', 'savelife' ),
            ]
        );
        $this->add_control(
            'text_limit',
            [
                'label'   => esc_html__( 'Text Limit', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 15,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_number',
            [
                'label'   => esc_html__( 'Number of post', 'savelife' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 3,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
            ]
        );
        $this->add_control(
            'query_orderby',
            [
                'label'   => esc_html__( 'Order By', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => array(
                    'date'       => esc_html__( 'Date', 'savelife' ),
                    'title'      => esc_html__( 'Title', 'savelife' ),
                    'menu_order' => esc_html__( 'Menu Order', 'savelife' ),
                    'rand'       => esc_html__( 'Random', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_order',
            [
                'label'   => esc_html__( 'Order', 'savelife' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => array(
                    'DESC' => esc_html__( 'DESC', 'savelife' ),
                    'ASC'  => esc_html__( 'ASC', 'savelife' ),
                ),
            ]
        );
        $this->add_control(
            'query_category',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Category', 'savelife'),
                'options' => get_categories_list(),
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

        $paged = savelife_set($_POST, 'paged') ? esc_attr($_POST['paged']) : 1;

        $this->add_render_attribute( 'wrapper', 'class', 'templatepath-savelife' );
        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => savelife_set( $settings, 'query_number' ),
            'orderby'        => savelife_set( $settings, 'query_orderby' ),
            'order'          => savelife_set( $settings, 'query_order' ),
            'paged'         => $paged
        );

        if ( savelife_set( $settings, 'query_exclude' ) ) {
            $settings['query_exclude'] = explode( ',', $settings['query_exclude'] );
            $args['post__not_in']      = savelife_set( $settings, 'query_exclude' );
        }

        if( savelife_set( $settings, 'query_category' ) ) $args['category_name'] = savelife_set( $settings, 'query_category' );
        $query = new \WP_Query( $args );
        $i=1;
        if ( $query->have_posts() ) { ?>
        
        <!-- news-section -->
        <section class="news-sections sec-pad">
            <div class="auto-container">
				<!-- Sec Title -->
                <div class="sec-title centered">
                    <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                    <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                </div>
                <div class="row clearfix">
                    <?php while ( $query->have_posts() ) : $query->the_post();
					$term_list = wp_get_post_terms(get_the_id(), 'category', array("fields" => "names")); ?>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <div class="news-block-ones wow fadeInUp animated" data-wow-delay="300ms" data-wow-duration="1500ms">
                            <div class="inner-box">
                                <figure class="image-box">
                                    <?php the_post_thumbnail('savelife_370x260'); ?>
                                    <a href="<?php echo esc_url(get_permalink(get_the_id())); ?>" class="link"><i class="flaticon-plus"></i></a>
                                </figure>
                                <div class="lower-content">
                                    <div class="inner">
                                        <div class="category"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><i class="far fa-folder"></i><?php echo implode( ', ', (array)$term_list ); ?></a></div>
                                        <div class="admin-box">
                                            <figure class="admin-thumb"><?php echo get_avatar( get_the_author_meta( 'ID' ), 40 ); ?></figure>
                                            <h6><?php the_author(); ?></h6>
                                            <span><?php esc_html_e('On', 'savelife'); ?> <?php echo get_the_date(); ?></span>
                                        </div>
                                        <h5><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h5>
                                        <div class="text"><?php echo wp_kses( wp_trim_words( get_the_content(), $settings['text_limit'] ), true); ?></div>
                                        <div class="link"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php esc_html_e('Read more', 'savelife'); ?><i class="fas fa-angle-right"></i></a></div>
                                        <div class="comment-box"><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comments'); ?>"><i class="far fa-comment-alt"></i><?php comments_number( '0', '1', '%' ); ?></a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
        <!-- news-section end -->

        <?php }

        wp_reset_postdata();
    }
}


