<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Get_In_Touch extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_get_in_touch';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Get In Touch', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'get_in_touch',
            [
                'label' => esc_html__( 'Get In Touch', 'savelife' ),
            ]
        );
		$this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'address_title',
            [
                'label'       => __( 'Address Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'address',
            [
                'label'       => __( 'Address', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'phone_title',
            [
                'label'       => __( 'Phone Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'phone',
            [
                'label'       => __( 'Phone Number', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'email_title',
            [
                'label'       => __( 'Email Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'email',
            [
                'label'       => __( 'Email Address', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'bottom_text',
            [
                'label'       => __( 'Bottom Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- Contact Info Section -->
        <section class="contact-info-section">
            <div class="auto-container">
                <!-- Sec Title -->
                <div class="title-box">
                    <div class="title"><?php echo wp_kses( $settings['subtitle'], true ); ?></div>
                    <h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
                    <div class="text"><?php echo wp_kses( $settings['text'], true ); ?></div>
                </div>
                
                <div class="row clearfix">
                    <?php if($settings['address_title'] and $settings['address']) { ?>
                    <!-- Info Column -->
                    <div class="info-column col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-column">
                            <div class="content">
                                <div class="icon-box"><span class="flaticon-pin"></span></div>
                                <ul>
                                    <li><strong><?php echo wp_kses( $settings['address_title'], true ); ?></strong></li>
                                    <li><?php echo wp_kses( $settings['address'], true ); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                    
                    <?php if($settings['phone_title'] and $settings['phone']) { ?>
                    <!-- Info Column -->
                    <div class="info-column col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-column">
                            <div class="content">
                                <div class="icon-box"><span class="flaticon-phone-call"></span></div>
                                <ul>
                                    <li><strong><?php echo wp_kses( $settings['phone_title'], true ); ?></strong></li>
                                    <li><a href="tel:<?php echo phone_number($settings['phone']); ?>"><?php echo wp_kses( $settings['phone'], true ); ?></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                    
                    <?php if($settings['email_title'] and $settings['email']) { ?>
                    <!-- Info Column -->
                    <div class="info-column col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-column">
                            <div class="content">
                                <div class="icon-box"><span class="flaticon-email-1"></span></div>
                                <ul>
                                    <li><strong><?php echo wp_kses( $settings['email_title'], true ); ?></strong></li>
                                    <li><a href="mailto:<?php echo sanitize_email( $settings['email'], true ); ?>"><?php echo sanitize_email( $settings['email'], true ); ?></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
                
                <div class="lower-text"><?php echo wp_kses( $settings['bottom_text'], true ); ?></div>
            </div>
        </section>
        <!-- End Contact Info Section -->
        
        <?php
    }
}
