<?php namespace SAVELIFEPLUGIN\Element;

class Elementor {
	static $widgets = array(
		//Home Page
		'slider_v1',
		'slider_v2',
		'slider_v3',
		'charity_collection',
		'welcome_our_donation',
		'our_recent_causes',
		'our_causes_v1',
		'upcoming_events',
		'call_to_action',
		'our_team_v1',
		'team_v3',
		'our_latest_news_v1',
		'our_blog_v1',
		'partners',
		'how_we_are',
		'help_us',
		'mission_and_goals_v1',
		'make_donation',
		'our_gallery_projects',
		'become_regular_volunteer',
		'testimonials_v1',
		'our_latest_news_v2',
		'mission_and_goals_v2',
		'facts_counter',
		'latest_events',
		'donate_now',
		'faqs_v1',
		'testimonials_v2',
		'our_latest_news_v3',
		'register_volunteer',
		'faqs_v2',
		'our_faqs',
		'our_team_v2',
		'testimonials_v3',
		'our_causes_v2',
		'events',
		'related_events',
		'projects',
		'get_in_touch',
		'contact_us',
		'google_map',
		'about_us_v1',
		'about_us_v2',
		'contact_info',
		//updated shortcodes
		'slider_v5',
		'services_slider',
		'about_us_v3',
		'urgent_causes',
		'donation_services',
		'upcoming_events_v2',
		'our_team_v3',
		'our_latest_news_v4',
		'our_gallery',
	);

	static function init() {
		add_action( 'elementor/init', array( __CLASS__, 'loader' ) );
		add_action( 'elementor/elements/categories_registered', array( __CLASS__, 'register_cats' ) );
	}

	static function loader() {

		foreach ( self::$widgets as $widget ) {

			$file = SAVELIFEPLUGIN_PLUGIN_PATH . '/elementor/' . $widget . '.php';
			if ( file_exists( $file ) ) {
				require_once $file;
			}

			add_action( 'elementor/widgets/widgets_registered', array( __CLASS__, 'register' ) );
		}
	}

	static function register( $elemntor ) {
		foreach ( self::$widgets as $widget ) {
			$class = '\\SAVELIFEPLUGIN\\Element\\' . ucwords( $widget );

			if ( class_exists( $class ) ) {
				$elemntor->register_widget_type( new $class );
			}
		}
	}

	static function register_cats( $elements_manager ) {

		$elements_manager->add_category(
			'savelife',
			[
				'title' => esc_html__( 'Savelife', 'savelife' ),
				'icon'  => 'fa fa-plug',
			]
		);
		$elements_manager->add_category(
			'templatepath',
			[
				'title' => esc_html__( 'Template Path', 'savelife' ),
				'icon'  => 'fa fa-plug',
			]
		);

	}
}

Elementor::init();