<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Charity_Collection extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_charity_collection';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Charity Collection', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'charity_collection',
            [
                'label' => esc_html__( 'Charity Collection', 'savelife' ),
            ]
        );
		$this->add_control(
            'bg_image',
            [
                'label' => __( 'Background Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'slides',
            [
                'label'   => esc_html__( 'FunFacts', 'savelife' ),
                'type' => Controls_Manager::REPEATER,
                'separator' => 'before',
                'default' =>
                    [

                    ],
                'fields' =>
                    [
                        [
                            'name' => 'title',
                            'label' => esc_html__('Title', 'savelife'),
                            'type' => Controls_Manager::TEXT,
                        ],
						[
                            'name' => 'solid_color',
                            'label' => esc_html__('Solid Color', 'savelife'),
                            'type' => Controls_Manager::COLOR,
                        ],
						[
                            'name' => 'theme_color',
                            'label' => esc_html__('Theme Color', 'savelife'),
                            'type' => Controls_Manager::COLOR,
                        ],
                        [
                            'name' => 'counter_stop',
                            'label' => esc_html__('Counter Stop', 'savelife'),
                            'type' => Controls_Manager::NUMBER,
                        ],
                    ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- Updated Donation Section -->
        <section class="updated-donation-section" style="background-image:url(<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>)">
            <div class="auto-container">
                <div class="row clearfix">
                    <div class="title-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <h2><?php echo wp_kses($settings['text'], true); ?></h2>
                        </div>
                    </div> 
                    
                    <!--Progress Column-->
                    <div class="progress-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">                    
                            <div class="row clearfix">
                            	<?php foreach($settings['slides'] as $key => $item) { ?>
                                <!-- Updated Process Block -->
                                <div class="updated-progress-block col-lg-4 col-md-4 col-sm-12">
                                    <div class="inner-box">
                                        <div class="graph-outer">
                                            <input type="text" class="dial" data-fgColor="<?php echo esc_attr($item['solid_color']); ?>" data-bgColor="<?php echo esc_attr($item['theme_color']); ?>" data-width="155" data-height="155" data-linecap="normal"  value="<?php echo esc_attr($item['counter_stop']); ?>">
                                            <div class="inner-text count-box"><span class="count-text" data-stop="<?php echo esc_attr($item['counter_stop']); ?>" data-speed="2000"></span><?php echo wp_kses($item['title'], true); ?></div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Updated Donation Section -->
        
        <?php
    }
}
