<?php namespace SAVELIFEPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V3 extends Widget_Base {

    /**
     * Get widget name.
     * Retrieve button widget name.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name() {
        return 'savelife_about_us_v3';
    }

    /**
     * Get widget title.
     * Retrieve button widget title.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'About Us V3', 'savelife' );
    }

    /**
     * Get widget icon.
     * Retrieve button widget icon.
     *
     * @since  1.0.0
     * @access public
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'fa fa-briefcase';
    }

    /**
     * Get widget categories.
     * Retrieve the list of categories the button widget belongs to.
     * Used to determine where to display the widget in the editor.
     *
     * @since  2.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'savelife' ];
    }

    /**
     * Register button widget controls.
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'about_us_v3',
            [
                'label' => esc_html__( 'About Us V3', 'savelife' ),
            ]
        );
		$this->add_control(
            'image',
            [
                'label' => __( 'Image', 'savelife' ),
				'separator' => 'before',
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'image1',
            [
                'label' => __( 'Image', 'savelife' ),
				'separator' => 'before',
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		
		$this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'text',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'author_text',
            [
                'label'       => __( 'Author Text', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'author_img',
            [
                'label' => __( 'Author Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'signature',
            [
                'label' => __( 'Signature Image', 'savelife' ),
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src(),],
            ]
        );
		$this->add_control(
            'designation',
            [
                'label'       => __( 'Text', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'features_list',
            [
                'label'       => __( 'Feature List', 'savelife' ),
                'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		$this->add_control(
            'data_bar',
            [
                'label'       => __( 'Data Fill Bar', 'savelife' ),
                'type'        => Controls_Manager::TEXT,
				'label_block' => true,
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );
		
        $this->end_controls_section();
    }

    /**
     * Render button widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post'); ?>
        
        <!-- About Section -->
        <section class="updated-about-section">
            <div class="auto-container">
                <div class="row clearfix">
                    
                    <!-- Image Column -->
                    <div class="image-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <div class="pattern-layer" style="background-image:url(<?php echo esc_url( get_template_directory_uri(). '/assets/images/background/pattern-2.png' );?>)"></div>
                            <div class="image wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                                <img src="<?php echo wp_get_attachment_url($settings['image']['id']); ?>" alt="<?php esc_html_e( 'Awesome Image', 'savelife' );?>" />
                            </div>
                            <div class="image-two wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                                <img src="<?php echo wp_get_attachment_url($settings['image1']['id']); ?>" alt="<?php esc_html_e( 'Awesome Image', 'savelife' );?>" />
                            </div>
                        </div>
                    </div>
                    
                    <!-- Content Column -->
                    <div class="content-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <!-- Sec Title -->
                            <div class="sec-title">
                                <div class="title"><?php echo wp_kses( $settings[ 'subtitle' ], true );?></div>
                                <h2><?php echo wp_kses( $settings[ 'title' ], true );?></h2>
                            </div>
                            <div class="text"><?php echo wp_kses( $settings[ 'text' ], true );?></div>
                            <div class="row clearfix">
                                <div class="column col-lg-6 col-md-6 col-sm-12">
                                    <!-- About Author Box -->
                                    <div class="about-author-box">
                                        <div class="box-inner">
                                            <div class="upper-box">
                                                <div class="color-layer"></div>
                                                <div class="author-text"><?php echo wp_kses( $settings[ 'author_text' ], true );?></div>
                                            </div>
                                            <div class="lower-box">
                                                <div class="lower-box-inner">
                                                    <div class="author-image">
                                                        <img src="<?php echo wp_get_attachment_url($settings['author_img']['id']); ?>" alt="<?php esc_html_e( 'Awesome Image', 'savelife' );?>" />
                                                    </div>
                                                    <div class="signature"><img src="<?php echo wp_get_attachment_url($settings['signature']['id']); ?>" alt="<?php esc_html_e( 'Awesome Image', 'savelife' );?>" /></div>
                                                    <div class="designation"><?php echo wp_kses( $settings[ 'designation' ], true );?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="column col-lg-6 col-md-6 col-sm-12">
									<?php $features_list = $settings['features_list'];
                                        if(!empty($features_list)){
                                        $features_list = explode("\n", ($features_list)); 
                                    ?>
                                    <ul class="list-style-one">
                                        <?php foreach($features_list as $features): ?>
                                        <li><?php echo wp_kses($features, true); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                    <?php } ?>
                                </div>
                            </div>
                            
                            <!-- Skills -->
                            <div class="skills">
                                <!-- Skill Item -->
                                <div class="skill-item">
                                    <div class="skill-bar">
                                        <div class="bar-inner">
                                            <div class="bar progress-line" data-width="<?php echo esc_attr( $settings[ 'data_bar' ] );?>">
                                                <div class="skill-percentage"><div class="count-box"><span class="count-text" data-speed="2000" data-stop="<?php echo esc_attr( $settings[ 'data_bar' ] );?>">0</span>%</div></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="skill-header clearfix">
                                        <div class="pull-left">
                                            <div class="skill-title">Total Donater's</div>
                                        </div>
                                        <div class="pull-right">
                                            <div class="grow">Grow is matter.</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    
                </div>
            </div>
        </section>
        <!-- End About Section -->

        <?php
    }
}
